#include <Inventor/Xt/SoXt.h>
#include <Inventor/SoPreferences.h>
#include <DialogViz/dialog/SoDialogViz.h>
#include <DialogViz/SoDialogVizAll.h>

#include <MeshVizXLM/mapping/MoMeshViz.h>

#include "DemoEclipse.h"
#include "gui/GuiDialogViz.h"

DemoEclipse::DemoEclipse(char **argv) : m_dialogViz(NULL), m_argv(argv)
{  
  // Initialize the new nodes class
  MoMeshViz::init();
  SoDialogViz::init();

  if (EGRID_STORAGE == 0)
    m_fileName = "EclipseGrids/demo_grid_1M.jik.bin";
  else 
    m_fileName = "EclipseGrids/demo_grid_1M.bin";

  m_gridPath = SoPreferences::getString("OIVHOME",".") + "/examples/data/MeshVizXLM/";
  m_demoPath = SoPreferences::getString("OIVHOME",".") + "/examples/source/MeshVizXLM/demonstrators/EclipseMeshViz/";
  m_filePath = m_demoPath + "EclipseMeshViz.iv";
  m_viewerPath = m_demoPath + "EclipseMeshVizViewer.iv";
}

DemoEclipse::~DemoEclipse()
{
  SoDialogViz::finish();
  MoMeshViz::finish();
  SoXt::finish();
}

void 
DemoEclipse::run() 
{

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(m_argv[0]) ;
  if (myWindow == NULL) exit(1) ;

  if (m_dialogViz == NULL)
    m_dialogViz = new GuiDialogViz(m_filePath.getString(), m_viewerPath.getString());
  m_dialogViz->start(myWindow);

  m_dialogViz->readMesh(m_gridPath.getString() + m_fileName); 
  SoXt::show(myWindow);

  SoXt::mainLoop();

  delete m_dialogViz;
  m_dialogViz = NULL;
}

