#ifndef _DemoSettings_H
#define _DemoSettings_H

//                GRID AND WRAPPER SETTINGS

// define type to store coordinates in Pillar Grid
// memory used = 8*sizeof(CoordT) per cell + 6*sizeof(CoordT) per pillar in the standard egrid storage.
// float by default
typedef float CoordT;

// define type to store active cell flag in Pillar Grid
// memory used = 1*sizeof(ActiveT) per cell
typedef char ActiveT;

// define type to store node indices in Cached Pillar Topology
// Not used when selecting the No Cache option in the gui
typedef unsigned int NodeIdT;

// Setting to 1 allows horizontal faults. PillarTopology will
// take into account faces connection along the k dimension.
// the wrappers will compare the vertices of the upper face 
// of a cell and the vertices of the lower face of its adjacent cell.
// Setting to 0 reduce by half the number of stored zcorns when using the
// embedded pillargrid generator and considerably speed up the whole 
// the process (generator, wrappers, extractions)
#define HORIZONTAL_FAULTS 0

// Use EGrid storage when set to 1, PillarGrid stores 8 zcorn values per cell as in
// a standard "egrid" file. Consecutive zcorn values in memory are along the i dimension, i.e
// the zcorn are stored in a kji layout. PillarGrid stores exactly 8*(ni)*(nj)*(nk) zcorns.
// Otherwise PillarGrid stores 8 zcorn values at each pillar level. Consecutive zcorn values 
// are along the k dimension, i.e zcorns are stored in a jik layout, meaning that successive 
// zcorns in memory follow a vertical pillar. PillarGrid stores exactly (8*(ni+1)*(nj+1)*(nk+1))
#define EGRID_STORAGE 0

//                OTHER SETTINGS

// When set to 1, displays extraction timings when down sampling the grid
// Off by default.
#define LOW_RES_TIMINGS 0
// When set to 1, displays extraction phase timings
// Off by default.
#define PHASE_TIMINGS 0
// Activate low resolution
#define ACTIVE_LOWRESOLUTION 1
// Activate mutli-threading
#define MULTITHREADING 1

#endif

