#ifndef _AuditorAnimation_H_
#define _AuditorAnimation_H_

#include "GuiDialogViz.h"

#include <DialogViz/auditors/SoDialogAuditor.h>

#include <Inventor/sensors/SoAlarmSensor.h>
#include <Inventor/sensors/SoTimerSensor.h>


class AuditorAnimation : public SoDialogAuditor 
{
public:
  AuditorAnimation(GuiDialogViz* gui);
  ~AuditorAnimation();

  int computeFrameFromSliderPosition(int slider_pos);
  int computeSliderPositionFromFrame(int frame);

  void setPlaybackPosition(int frame);
  bool isPlaybackFinished();
  void advancePlaybackPosition();

  void startAnimation();
  void stopAnimation();
  void setAnimationDelay(double delay);

  void animationStepCB();

  void dialogPushButton(SoDialogPushButton* button);
  void dialogIntegerSlider(SoDialogIntegerSlider* slider);
  void dialogRealSlider(SoDialogRealSlider* slider);
  void dialogCheckBox(SoDialogCheckBox* toggle);

protected:
  void refreshFrame();
  void setFrame(int frame);
  void setSliderPosition(int frame);


private:
  GuiDialogViz*  m_gui;

  int m_frame;
  static const int FRAME_LIMIT = 99;

  double m_animation_delay;

  SoTimerSensor* m_timer;
  bool m_playing;

  bool m_loop;
};

#endif


