#ifndef  _AUDITORCHECKSWITCH_H_
#define  _AUDITORCHECKSWITCH_H_

#include <DialogViz/auditors/SoDialogCheckBoxAuditor.h> 
#include <DialogViz/dialog/SoDialogCheckBox.h>
#include <Inventor/nodes/SoSwitch.h>

class AuditorCheckSwitchChild : public SoDialogCheckBoxAuditor 
{
public:
  AuditorCheckSwitchChild(SoSwitch* sswitch, SoDialogCheckBox* checkBox=NULL) 
    : m_switch(sswitch) 
  { 
    m_aCheckBox = checkBox;
  }
  
  void dialogCheckBox(SoDialogCheckBox* checkBox) 
  {
    if (checkBox->state.getValue() == TRUE)
    {
      m_switch->whichChild = 0;
      if(m_aCheckBox && m_aCheckBox->state.getValue() == TRUE){
        m_aCheckBox->state.setValue(FALSE);
        m_aCheckBox->applyDlgCptAuditor();
      }
    }
    else
      m_switch->whichChild = 1;
  }

private:
  SoSwitch* m_switch;
  SoDialogCheckBox* m_aCheckBox;
};

class AuditorCheckSwitch : public SoDialogCheckBoxAuditor 
{
public:
  AuditorCheckSwitch(SoSwitch* sswitch, SoDialogCheckBox* checkBox=NULL) 
    : m_switch(sswitch) 
  { 
    m_aCheckBox = checkBox;
  }
  
  void dialogCheckBox(SoDialogCheckBox* checkBox) 
  {
    if (checkBox->enable.getValue() == TRUE && checkBox->state.getValue() == TRUE)
    {
      m_switch->whichChild = SO_SWITCH_ALL;
      if(m_aCheckBox && m_aCheckBox->state.getValue() == TRUE){
        m_aCheckBox->state.setValue(FALSE);
        m_aCheckBox->applyDlgCptAuditor();
      }
    }
    else
      m_switch->whichChild = SO_SWITCH_NONE;
  }

private:
  SoSwitch* m_switch;
  SoDialogCheckBox* m_aCheckBox;
};

#endif


