#include "gui/GuiDialogViz.h"
#include "scenegraph/OivSceneGraph.h"
#include "gui/AuditorDownSampling.h"

#include <DialogViz/auditors/SoDialogAuditor.h> 
#include <DialogViz/dialog/SoDialogIntegerSlider.h>
#include <DialogViz/dialog/SoDialogCheckBox.h>
#include <DialogViz/dialog/SoDialogPushButton.h>


//---------------------------------------------------------------------------
void 
AuditorDownSampling::dialogIntegerSlider(SoDialogIntegerSlider* slider)
{
  if (slider->auditorID.getValue() == "resolutionslider")
  {
    double resolutionRatio = slider->enable.getValue() ? slider->value.getValue()/100.0 : 1.0;
    m_gui->updateResolution(resolutionRatio);
  }
  else if (slider->auditorID.getValue() == "fullresdelay")
  {
    m_gui->getSceneGraph()->setFullResolutionDelay(slider->value.getValue());
  }
}

//---------------------------------------------------------------------------
void 
AuditorDownSampling::dialogCheckBox(SoDialogCheckBox* checkBox)
{
  if (checkBox->auditorID.getValue() == "autodownsampling")
    m_gui->enableAutoDownSampling(checkBox->enable.getValue() && checkBox->state.getValue());
}

//---------------------------------------------------------------------------
void 
AuditorDownSampling::dialogPushButton(SoDialogPushButton* button)
{
  if (button->auditorID.getValue() == "previewbutton")
    m_gui->getSceneGraph()->switchToFullResolutionMesh();
}
