#include "gui/AuditorDrawStyle.h"
#include "scenegraph/OivSceneGraph.h"

#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>
#include <DialogViz/dialog/SoDialogCheckBox.h>
#include <DialogViz/dialog/SoDialogRealSlider.h>
#include <DialogViz/dialog/SoDialogComboBox.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/SbString.h>

//---------------------------------------------------------------------------
void 
AuditorDrawStyle::dialogCheckBox(SoDialogCheckBox* checkBox) 
{
  bool checkBoxValue = checkBox->state.getValue(); 
  if (checkBox->auditorID.getValue() == "faceCheck")
    m_ds->displayFaces = checkBoxValue;
  else if (checkBox->auditorID.getValue() == "edgeCheck")
    m_ds->displayEdges = checkBoxValue;
  else if (checkBox->auditorID.getValue() == "pointCheck")
    m_ds->displayPoints = checkBoxValue;
}

void 
AuditorDrawStyle::dialogRealSlider(SoDialogRealSlider* slider)
{
  if (slider->auditorID.getValue() == "FadingThreshold")
    m_ds->fadingThreshold = slider->value.getValue();
  else if (slider->auditorID.getValue() == "fssa")
    m_gui->setFSSA(slider->value.getValue());
}

void 
AuditorDrawStyle::dialogComboBox(SoDialogComboBox* combobox)
{
  if (combobox->auditorID.getValue() == "transparencytype")
  {
    m_gui->updateTransparencyType(transparencyTypes[combobox->items[combobox->selectedItem.getValue()]]);
  }

  if (combobox->auditorID.getValue() == "colormaps")
  {
    m_sceneGraph->updateColorMap(colorMaps[combobox->items[combobox->selectedItem.getValue()]]);
  }
}



