#ifndef _AuditorDrawstyle_H_
#define _AuditorDrawstyle_H_

#include "gui/GuiDialogViz.h"
#include "scenegraph/OivSceneGraph.h"

#include <DialogViz/auditors/SoDialogAuditor.h> 
class SoDialogRealSlider;
class SoDialogCheckBox;
class SoDialogComboBox;
class MoDrawStyle;

class AuditorDrawStyle : public SoDialogAuditor 
{
public:
  AuditorDrawStyle(GuiDialogViz* gui) : m_ds(gui->getSceneGraph()->getDrawStyle()), m_sceneGraph (gui->getSceneGraph()), m_gui (gui)
  {
    transparencyTypes[SbString("NO_SORT")] = SoGLRenderAction::NO_SORT;
    transparencyTypes[SbString("OPAQUE_FIRST")] = SoGLRenderAction::OPAQUE_FIRST;
    transparencyTypes[SbString("SORTED_OBJECT")] = SoGLRenderAction::SORTED_OBJECT;
    transparencyTypes[SbString("SORTED_PIXEL")] = SoGLRenderAction::SORTED_PIXEL;

    colorMaps[SbString("NONE")] = MoPredefinedColorMapping::NONE;
    colorMaps[SbString("GREY")] = MoPredefinedColorMapping::GREY;
    colorMaps[SbString("TEMPERATURE")] = MoPredefinedColorMapping::TEMPERATURE;
    colorMaps[SbString("PHYSICS")] = MoPredefinedColorMapping::PHYSICS;
    colorMaps[SbString("STANDARD")] = MoPredefinedColorMapping::STANDARD;
    colorMaps[SbString("GLOW")] = MoPredefinedColorMapping::GLOW;
    colorMaps[SbString("BLUE_RED")] = MoPredefinedColorMapping::BLUE_RED;
    colorMaps[SbString("SEISMIC")] = MoPredefinedColorMapping::SEISMIC;
    colorMaps[SbString("BLUE_WHITE_RED")] = MoPredefinedColorMapping::BLUE_WHITE_RED;
    colorMaps[SbString("INTENSITY")] = MoPredefinedColorMapping::INTENSITY;
    colorMaps[SbString( "RAINBOW_TURBO" )] = MoPredefinedColorMapping::RAINBOW_TURBO;
  }

  void dialogRealSlider (SoDialogRealSlider* slider);
  void dialogCheckBox(SoDialogCheckBox* component);
  void dialogComboBox(SoDialogComboBox* combobox);

private:
  MoDrawStyle* m_ds;
  OivSceneGraph* m_sceneGraph;
  GuiDialogViz* m_gui;
  std::map<SbString, SoGLRenderAction::TransparencyType> transparencyTypes;
  std::map<SbString, MoPredefinedColorMapping::PredefColorMapping> colorMaps;
};

#endif


