#include "gui/GuiDialogViz.h"
#include "scenegraph/OivSceneGraph.h"
#include "gui/AuditorFilter.h"
#include "wrappers/CellFilter.h"

#include <DialogViz/auditors/SoDialogAuditor.h> 
#include <DialogViz/dialog/SoDialogCheckBox.h>
#include <DialogViz/dialog/SoDialogIntegerSlider.h>
#include <DialogViz/dialog/SoDialogRealSlider.h>
#include <DialogViz/dialog/SoDialogComboBox.h>

//---------------------------------------------------------------------------
void 
AuditorFilter::dialogCheckBox(SoDialogCheckBox* checkBox) 
{
  if (checkBox->auditorID.getValue() == "roicheck")
  {
    bool checkBoxValue = checkBox->state.getValue(); 
    m_sceneGraph->enableROIFiltering(checkBoxValue);
  }
  else if (checkBox->auditorID.getValue() == "datareverse")
  {
    m_reverse = checkBox->state.getValue();

    const CellFilter& roi = m_sceneGraph->getROIDataRangeFilter();
    roi.setReverse(m_reverse);
    const CellFilter& lowRoi = m_sceneGraph->getlowROIDataRangeFilter();
    lowRoi.setReverse(m_reverse);
   
    m_sceneGraph->updateFilter();
  }
}


//---------------------------------------------------------------------------
void 
AuditorFilter::dialogIntegerSlider(SoDialogIntegerSlider* slider)
{
  size_t roiBoundId = 0;
  if (slider->auditorID.getValue() == "roiimin")
    roiBoundId = 0;
  else if (slider->auditorID.getValue() == "roiimax")
    roiBoundId = 1;
  else if (slider->auditorID.getValue() == "roijmin")
    roiBoundId = 2;
  else if (slider->auditorID.getValue() == "roijmax")
    roiBoundId = 3;
  else if (slider->auditorID.getValue() == "roikmin")
    roiBoundId = 4;
  else if (slider->auditorID.getValue() == "roikmax")
    roiBoundId = 5;

  size_t roiBounds[6];
  const CellFilter& roi = m_sceneGraph->getROIDataRangeFilter();
  roi.getROI(roiBounds[0],roiBounds[1],roiBounds[2],roiBounds[3],roiBounds[4],roiBounds[5]);

  roiBounds[roiBoundId] = slider->value.getValue();
  if (m_sceneGraph->setROIFiltering(roiBounds[0],roiBounds[1],roiBounds[2],roiBounds[3],roiBounds[4],roiBounds[5]))
    m_sceneGraph->switchToLowResolutionMesh();
}

void 
AuditorFilter::dialogRealSlider(SoDialogRealSlider* slider)
{
  double vmin, vmax;
  const CellFilter& roi = m_sceneGraph->getROIDataRangeFilter();
  roi.getDataRange(vmin,vmax);
  if (slider->auditorID.getValue() == "pmin")
    vmin = slider->value.getValue();
  else if (slider->auditorID.getValue() == "pmax")
    vmax = slider->value.getValue();

  if (m_sceneGraph->setDataRangeFiltering(vmin,vmax))
    m_sceneGraph->switchToLowResolutionMesh();
}

void
AuditorFilter::dialogComboBox(SoDialogComboBox* combobox)
{
  if (combobox->auditorID.getValue() == "FilterProperty")
  {
    std::string property(combobox->items[combobox->selectedItem.getValue()].getString());
    if (m_gui->updateDataRangeSliders(property))
      m_sceneGraph->switchToLowResolutionMesh();
  }
}
