#include "gui/GuiDialogViz.h"
#include "scenegraph/OivSceneGraph.h"
#include "gui/AuditorGeometry.h"

#include <DialogViz/auditors/SoDialogAuditor.h> 
#include <DialogViz/dialog/SoDialogRealSlider.h>
#include <DialogViz/dialog/SoDialogIntegerSlider.h>
#include <DialogViz/dialog/SoDialogCheckBox.h>
#include <DialogViz/dialog/SoTopLevelDialog.h>
#include <DialogViz/dialog/SoDialogComboBox.h>
#include <DialogViz/dialog/SoDialogPushButton.h>
#include <Inventor/sensors/SoTimerSensor.h>

AuditorGeometry::AuditorGeometry(GuiDialogViz* gui) 
  : m_sceneGraph(gui->getSceneGraph()), m_gui(gui), m_firstDialogPushButton(true)
{
  m_currentIndex.resize(3); 
  m_currentStep.resize(3);
  m_currentThickness.resize(3,1);
}

//---------------------------------------------------------------------------

void 
AuditorGeometry::dialogRealSlider (SoDialogRealSlider* slider)
{
  bool downSampling = false;
  SbString auditorId = slider->auditorID.getValue();
  if (auditorId == "skintrans")
    m_sceneGraph->setSkinTransparency(slider->value.getValue());
  else if (auditorId == "planeslicerot") {
    downSampling = m_sceneGraph->rotateGeomSlice(slider->value.getValue());
  }
  else if (auditorId == "isovalue") {
    downSampling = m_sceneGraph->setIsosurfaceValue(slider->value.getValue());
  }
  else if (auditorId == "zscale")
    m_sceneGraph->getTransform()->scaleFactor.setValue(1, 1, slider->value.getValue());

  if (downSampling)
    m_sceneGraph->switchToLowResolutionMesh();
}

void 
AuditorGeometry::dialogIntegerSlider (SoDialogIntegerSlider* slider)
{
  SbString auditorId = slider->auditorID.getValue();
  int sliceId=-1;
  if (auditorId == "logicalslicenumber0" || auditorId == "logicalslicethickness0" || auditorId == "multipleslab0")
    sliceId=0;
  else if (auditorId == "logicalslicenumber1" || auditorId == "logicalslicethickness1" || auditorId == "multipleslab1")
    sliceId=1;
  else if (auditorId == "logicalslicenumber2" || auditorId == "logicalslicethickness2" || auditorId == "multipleslab2")
    sliceId=2;

  if (sliceId >= 0 && sliceId < 3 )
  {
    if (slider->label.getValue() == "slab index")
      if (m_sceneGraph->moveSlab(sliceId,slider->value.getValue(), m_currentStep[sliceId]))
      {
        m_sceneGraph->switchToLowResolutionMesh();
        m_currentIndex[sliceId] = slider->value.getValue();
      }
    if (slider->label.getValue() == "thickness")
      if (m_sceneGraph->changeSlabThickness(sliceId,slider->value.getValue()))
      {
        m_sceneGraph->switchToLowResolutionMesh();
        m_currentThickness[sliceId] = slider->value.getValue();
      }
  }
  if (auditorId == "multipleslab0")
  {
    m_sceneGraph->updateSlabs(sliceId,slider->value.getValue(), m_currentIndex[sliceId], m_currentThickness[sliceId]);
    m_currentStep[0] = slider->value.getValue();
  }
  else if (auditorId == "multipleslab1")
  {
     m_sceneGraph->updateSlabs(sliceId,slider->value.getValue(), m_currentIndex[sliceId], m_currentThickness[sliceId]);
     m_currentStep[1] = slider->value.getValue();
  }
  else if (auditorId == "multipleslab2")
  {
     m_sceneGraph->updateSlabs(sliceId,slider->value.getValue(), m_currentIndex[sliceId], m_currentThickness[sliceId]);
     m_currentStep[2] = slider->value.getValue();
  }

}

void 
AuditorGeometry::dialogComboBox(SoDialogComboBox* component)
{
  SbString auditorId = component->auditorID.getValue();
  if (auditorId == "planeslicenormal")
  {
    int selectedItem = component->selectedItem.getValue();
    m_sceneGraph->setGeomSlice(selectedItem);
    // reset rotate slider
    SoDialogRealSlider* rotslider = (SoDialogRealSlider*)m_gui->m_topLevelDialog->searchForAuditorId("planeslicerot");
    if (rotslider != NULL)
      rotslider->value = 0;
  }
  else if (auditorId == "IsoProperty")
  {
    std::string property(component->items[component->selectedItem.getValue()].getString());
    m_sceneGraph->selectIsoScalar(property);
    m_gui->updateIsosurfSlider(property);
  }

}

//---------------------------------------------------------------------------
void
AuditorGeometry::dialogPushButton(SoDialogPushButton* button)
{
  if (m_firstDialogPushButton) 
    m_firstDialogPushButton = false;
  else if (button->auditorID.getValue() == "fenceclearbutton")
  {
    m_sceneGraph->clearFence();
  }
}
