#ifndef _AUDITORGEOMETRY_H_
#define _AUDITORGEOMETRY_H_

#include "gui/GuiDialogViz.h"
#include "scenegraph/OivSceneGraph.h"

#include <DialogViz/auditors/SoDialogAuditor.h> 
class SoDialogRealSlider;
class SoDialogIntegerSlider;
class SoDialogComboBox;
class SoDialogPushButton;

class AuditorGeometry : public SoDialogAuditor 
{
public:
  AuditorGeometry(GuiDialogViz* gui);

  void dialogRealSlider (SoDialogRealSlider* slider);
  void dialogIntegerSlider (SoDialogIntegerSlider* slider);
  void dialogComboBox(SoDialogComboBox* component);
  void dialogPushButton(SoDialogPushButton* button);

private:
  OivSceneGraph*& m_sceneGraph;
  GuiDialogViz*  m_gui;
  bool m_firstDialogPushButton;
  std::vector<int> m_currentIndex;
  std::vector<int> m_currentStep;
  std::vector<int> m_currentThickness;
};

#endif


