#include "gui/AuditorProperties.h"
#include "scenegraph/OivSceneGraph.h"

#include <DialogViz/dialog/SoTopLevelDialog.h>
#include <DialogViz/dialog/SoDialogCheckBox.h>
#include <DialogViz/dialog/SoDialogRealSlider.h>
#include <DialogViz/dialog/SoDialogComboBox.h>
#include "DialogViz/dialog/SoDialogGroup.h"
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/SbString.h>

//---------------------------------------------------------------------------
void 
AuditorProperties::dialogCheckBox(SoDialogCheckBox* checkBox)
{
  bool checkBoxState = checkBox->state.getValue();
  bool changingState = false;
  if (checkBox->auditorID.getValue() == "depthCheck")
  {
    changingState = m_activeDetph != checkBoxState;
    m_activeDetph = checkBoxState;
  }
  else if (checkBox->auditorID.getValue() == "poroCheck")
  {
    changingState = m_activePorosity != checkBoxState;
    m_activePorosity = checkBoxState;
  }

  if (changingState)
  {
    if (checkBoxState)
      ++m_activePropertyCount;
    else if (m_activePropertyCount != 0)
      --m_activePropertyCount;

    ((SoDialogRealSlider*)m_gui.m_topLevelDialog->searchForAuditorId("combiningWeight"))->enable = m_activePropertyCount == 2;
    ((SoDialogGroup*)m_gui.m_topLevelDialog->searchForAuditorId("animationtab"))->enable = m_activePropertyCount != 0;

    if (m_activePropertyCount == 0)
      m_sceneGraph.displayColor();
    else if (m_activePropertyCount == 2)
      m_sceneGraph.displayCombined();
    else if (m_activeDetph)
      m_sceneGraph.displayDepth();
    else if (m_activePorosity)
      m_sceneGraph.displayPorosity();
  }
}

void 
AuditorProperties::dialogRealSlider(SoDialogRealSlider* slider)
{
  if (slider->auditorID.getValue() == "combiningWeight")
  {
    m_sceneGraph.setCombiningWeight(slider->value.getValue());
  }
}



