#include "gui/AuditorTimer.h"

#include <DialogViz/auditors/SoDialogAuditor.h> 
#include <DialogViz/dialog/SoDialogCheckBox.h>

static bool s_display_timer = true;

//---------------------------------------------------------------------------
void display_time(const std::string &what, double timeElapsed)
{
  if (s_display_timer)
    std::cout<< what << " in " << timeElapsed << " seconds" << std::endl;
}

//---------------------------------------------------------------------------
void display(const std::string &what)
{
  if (s_display_timer)
    std::cout<< what << std::endl;
}

//---------------------------------------------------------------------------
void 
AuditorTimer::dialogCheckBox(SoDialogCheckBox* checkBox)
{
  if (checkBox->auditorID.getValue() == "timercheck")
    s_display_timer = (checkBox->state.getValue() == TRUE);
}
