#ifndef _GUIDIALOGVIZ_H
#define _GUIDIALOGVIZ_H

#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/STL/string>
#include <Inventor/STL/vector>
#include <Inventor/SbVec.h>

#include "pillargrid/PillarGrid.h"
#include "pillargrid/PillarGridReader.h"

#include "wrappers/PillarMesh.h"
#include "scenegraph/OivSceneGraph.h"

#include <Inventor/STL/limits>

class SoTopLevelDialog;
class SoDialogComboBox;
class SoAlarmSensor;
class SoAction;
class SoXtExaminerViewer;
class SoMemoryBufferCompression; 

class GuiDialogViz
{
public:
  GuiDialogViz(std::string ivDialogFile, std::string ivDialogFileForViewer );
  virtual ~GuiDialogViz();
  
  OivSceneGraph*& getSceneGraph();
  
  SoTopLevelDialog* m_topLevelDialog;
  SoTopLevelDialog* m_viewerTopLevelDialog;

  void readMesh(const std::string& filename);
  void saveMesh(const std::string& filename);

  void start(Widget window);
  void buildMainWindow(Widget window);

  void setFrame(int frame) {
    m_sceneGraph->setFrame(frame);
  }

  void enableAutoDownSampling(bool enable);

  void updateResolution(double resolutionRatio);
  bool updateDataRangeSliders(const std::string& name);
  void updateIsosurfSlider(const std::string& name);
  void updateGUI();
  void updateTransparencyType(SoGLRenderAction::TransparencyType newType);
  void setFSSA(float quality);
  void snapshot();


  int m_numSnapshot;
  std::string m_gridName; 

  static void viewerFPSCB( float fps, void *userData, SoXtViewer *viewer );
  

protected:
  PillarGrid* m_grid;
  PillarMesh* m_eclipseMesh;
  OivSceneGraph* m_sceneGraph;

  virtual void buildGui();
  
  virtual void loadMesh(PillarGrid& grid);
  virtual Widget init();
  virtual void update();



private:
  void buildAuditorGeometryPanel();
  void buildAuditorPropertiesPanel();
  void buildAuditorHullPanel();
  void buildAuditorLogicalSlice(int id);
  void buildAuditorRoiPanel();
  void buildAuditorAnimationPanel();
  void buildAuditorDrawStylePanel();

  void setSliders(int defaultDimI = -1, int defaultDimJ = -1, int defaultDimK = -1, float defaultMax = -std::numeric_limits<float>::max());
  
  void initGeometryPanel();
  void initPropertiesPanel();
  void initHullPanel();
  void initRoiPanel();
  void initLogicalSlice(int id);
  void initRoiSlider(std::string sliderId, int roiBoundId, int roiInitValue, int roiMaxValue);
  void initDataRangeSlider(std::string sliderId, int roiBoundId, float dataMinValue,float dataInitValue, float dataMaxValue);
  void initAnimationPanel();
  void initDrawStylePanel();
  void initInfoPanel();

  std::string m_ivDialogFile;
  std::string m_ivDialogFileForViewer;

  Widget m_widget;
  SoXtExaminerViewer *m_viewer;

  bool m_init;
};


inline OivSceneGraph*&
GuiDialogViz::getSceneGraph()
{
  return m_sceneGraph;
}
#endif


