#ifndef _CrackFunctor_H_
#define _CrackFunctor_H_

class CrackFunctor 
{
public:
  virtual float operator() (size_t i, size_t j) const = 0;
  virtual ~CrackFunctor() {}
};

class StepICrackFctor : public CrackFunctor
{
public:
  StepICrackFctor(size_t cst, float offset) : m_cst(cst), m_offset(offset) {}
  float operator() (size_t i, size_t /*j*/) const
  {
    return i< m_cst ? m_offset : 0;
  }
private:
  size_t m_cst;
  float m_offset;
};

class StepJCrackFctor : public CrackFunctor
{
public:
  StepJCrackFctor(size_t cst, float offset) : m_cst(cst), m_offset(offset) {}
  float operator() (size_t /*i*/, size_t j) const
  {
    return j< m_cst ?  m_offset : 0;
  }
private:
  size_t m_cst;
  float m_offset;
};

class LinearCrackFctor : public CrackFunctor
{
public:
  LinearCrackFctor(float a, float b, float offset) : m_a(a), m_b(b), m_offset(offset) {}
  float operator() (size_t i, size_t j) const
  {
    return m_a * (float)i + m_b < (float)j ?  m_offset : 0;
  }
private:
  float m_a;
  float m_b;
  float m_offset;
};

#endif


