#include <cstdio>
#include <string.h>
#include <Inventor/STL/string>
#include <Inventor/STL/cassert>
#include <Inventor/STL/limits>
#include <Inventor/STL/algorithm>
#include "Grid.h"

#include <Inventor/STL/iostream>

CoordT Grid::m_undef = (CoordT)UNDEF;

Grid::Grid(): m_iDim(0), m_jDim(0), m_kDim(0), m_numHFacesAtKLevel(2),
              m_coord(0), m_zcorn(0),
              m_actnum(0), m_numNonActiveCells(0),
              m_minMaxUpdated(false)
{
}

bool Grid::empty() const
{
  return m_iDim == 0 || m_jDim == 0 || m_kDim == 0;
}

int Grid::generate_pillar_vertex(CoordT P12[6],CoordT zcorn, CoordT xyz[3]) const
{
  float x1,y1,z1,x2,y2,z2;
  x1 = P12[0]; y1 = P12[1]; z1 = P12[2];
  x2 = P12[3]; y2 = P12[4]; z2 = P12[5];

  if ((x1==x2) && (y1==y2))
  {
    xyz[0]=x1; xyz[1]=y1;
  }
  else
  {
    if (z1==z2)
      return 0;
    float a = (zcorn-z1)/(z2-z1);
    float b = (1-a);
    xyz[0] = b*x1+a*x2;
    xyz[1] = b*y1+a*y2;
  }

  xyz[2]= (CoordT) zcorn;
  return 1;
}

void Grid::updateMinMax()
{
  m_min[0] = m_min[1] = m_min[2] = std::numeric_limits<CoordT>::max();
  m_max[0] = m_max[1] = m_max[2] = std::numeric_limits<CoordT>::min();
  size_t ncoord = m_coord.size();
  for (size_t np = 0; np < ncoord; ++np)
  {
    m_min[0] = std::min(m_min[0],m_coord[np++]);
    m_min[1] = std::min(m_min[1],m_coord[np++]);
	  np++;
    m_max[0] = std::max(m_max[0],m_coord[np++]);
    m_max[1] = std::max(m_max[1],m_coord[np++]);
  }
  for (size_t nz = 0; nz < m_zcorn.size(); ++nz)
  {
    CoordT z = m_zcorn[nz];
    if (z != UNDEF)
    {
      if (m_min[2] > z)
        m_min[2] = z;
      else if (m_max[2] < z)
        m_max[2] = z;
    }
  }
  m_minMaxUpdated = true;
}

void  Grid::clear()
{
  m_iDim = 0;
  m_jDim = 0;
  m_kDim = 0;
  // free memory
  m_coord.clear();
  m_zcorn.clear();
  m_actnum.clear();

  if (m_poro.size() != 0) m_poro.clear();
}
