#ifndef _LevelFunctor_H_
#define _LevelFunctor_H_

#include <math.h>

class LevelFunctor 
{
public:

  virtual ~LevelFunctor() {}

  virtual float operator() (float x, float y) const = 0;
  virtual float getMin() const = 0;
  virtual float getMax() const = 0;
};

class ConstantFctor : public LevelFunctor
{
public:
  ConstantFctor(float cst) { m_cst = cst; }
  float operator() (float /*x*/, float /*y*/) const
  {
    return m_cst;
  }
  float getMin() const {return m_cst;}
  float getMax() const {return m_cst;}
private:
  float m_cst;
};

class CosFctor : public LevelFunctor
{
public:
  CosFctor(float alpha, float beta, float cst) 
  { 
    m_alpha = alpha;
    m_beta = beta;
    m_cst = cst; 
  }
  float operator() (float x, float /*y*/) const
  {
    return m_beta * (float)cos(m_alpha * x) + m_cst;
  }
  float getMin() const {return - m_beta + m_cst;}
  float getMax() const {return m_beta + m_cst;}
private:
  float m_alpha;
  float m_beta;
  float m_cst;
};

class SinFctor : public LevelFunctor
{
public:
  SinFctor(float alpha, float beta, float cst) 
  { 
    m_alpha = alpha;
    m_beta = beta;
    m_cst = cst; 
  }
  float operator() (float x, float /*y*/) const
  {
    return m_beta * (float)sin(m_alpha * x) + m_cst;
  }
  float getMin() const {return - m_beta + m_cst;}
  float getMax() const {return m_beta + m_cst;}
private:
  float m_alpha;
  float m_beta;
  float m_cst;
};

class CosSinFctor : public LevelFunctor
{
public:
  CosSinFctor(float alpha1, float beta1, float alpha2, float beta2, float cst) 
  { 
    sinor = new SinFctor(alpha2,beta2,0);
    cosor = new CosFctor(alpha1,beta1,0);
    m_cst = cst; 
  }
  ~CosSinFctor()
  {
    delete sinor;
    delete cosor;
  }
  float operator() (float x, float y) const
  {
    return  (*cosor)(x,y)*(*sinor)(y,x) + m_cst;
  }
  float getMin() const {return sinor->getMin()*cosor->getMin() + m_cst;}
  float getMax() const {return sinor->getMax()*cosor->getMax() + m_cst;}
private:
  SinFctor* sinor;
  CosFctor* cosor;
  float m_cst;
};

#endif


