#ifndef _PILLAREGRID_H_
#define _PILLAREGRID_H_

#include "Grid.h"

class PillarGridGenerator;

// This type of PillarGrid must store 8 zcorn values per level at each pillar. 
// Consecutive zcorn values are along the k dimension 
// The total number of zcorn is 8(nx*ny*nz)
class PillarEGrid : public Grid
{
public:
  friend class PillarGridGenerator;
  friend class PillarGridReader;

  // return 8 zcorns if HORIZONTAL_FAULTS, 4 zcorns otherwise
  void getPillarZCorns(size_t i, size_t j, size_t k, std::pair<CoordT,size_t> indexedZCorns[8]) const;
  void computePillarVertex(size_t zcornId, CoordT xyz[3]) const;
  int generate_cell_vertices(size_t i,size_t j,size_t k,CoordT xyz[24], const size_t reindex[2][2][2]) const;
  bool isValid(size_t i,size_t j,size_t k) const;
  CoordT get_zcorn(size_t i,size_t j,size_t k) const;
  CoordT get_porosity(size_t i,size_t j,size_t k) const;

  // return the corresponding zcorn index in the next upper cell face along the same pillar
  size_t getNextUpperCellFaceZCornId(size_t zcornId) const { return zcornId + m_numHFacesAtKLevel*m_4DimIDimJ; }
  // return the corresponding next upper face zcorn index along the same pillar
  size_t getNextUpperFaceZCornId(size_t zcornId) const { return zcornId + m_4DimIDimJ; }

private:
  // methods for readers to fill up the grid 
  void setDim(size_t numCellI, size_t numCellJ, size_t numCellK);

  size_t m_4DimIDimJ;
  size_t m_2DimI;

};

inline bool  
PillarEGrid::isValid(size_t i,size_t j,size_t k) const 
{
  return Grid::isValid((k*m_iDim*m_jDim)+j*m_iDim+i);
}

#endif


