#ifndef _PillarGridGenerator_H
#define _PillarGridGenerator_H

#define EPSILON 0.001
#define READBINARY 1
#define GENERATEMASK 1
#include "pillargrid/PillarGrid.h"
#include "pillargrid/LevelFunctor.h"
#include "pillargrid/CrackFunctor.h"

class PillarGridGenerator 
{

public:
  PillarGridGenerator();
  ~PillarGridGenerator();

	void generate(PillarGrid& pillarGrid, size_t numCellI, size_t numCellJ, size_t numCellK, float maxX, float maxY);
  void generate(PillarGrid& pillarGrid, const std::string& filename);
  void clear();

private:
  void addLevelFunctor( const LevelFunctor* levelFct);
  void addCrackFunctor( const CrackFunctor* crackFct);

  size_t generateNonActiveCells(PillarEGrid& mesh, float maxX, float maxY);
  size_t generateNonActiveCells(PillarGridJIK& mesh, float maxX, float maxY);
	size_t generateCoord(PillarGrid& mesh, float maxX, float maxY);
  size_t generateZCornTopDown(PillarEGrid& mesh, float maxX, float maxY);
  size_t generateZCornTopDown(PillarGridJIK& mesh, float maxX, float maxY);
  float computeOffset(size_t i, size_t j);

  // level function
  std::vector< const LevelFunctor* > m_levelFctors;
  // crack function
  std::vector< const CrackFunctor* > m_crackFctors;

  static size_t m_neighbourPillar[4][2];
  static int m_neighbourCells[4][2];

};

#endif


