#ifndef _PillarGridJIK_H_
#define _PillarGridJIK_H_

#include "Grid.h"

// This type of PillarGrid must store 8 zcorn values per level at each pillar. 
// Consecutive zcorn values are along the k dimension 
// The total number of zcorn is (8*(ni+1)*(nj+1)*(nk+1))

class PillarGridJIK : public Grid
{
public:
  friend class PillarGridGenerator;
  friend class PillarGridReader;

  PillarGridJIK();

  virtual ~PillarGridJIK() {}

  // return 8 zcorns if HORIZONTAL_FAULTS, 4 zcorns otherwise
  // return a pointer to the first zcorn and its index in the table
  size_t getPillarZCorns(size_t i, size_t j, size_t k, const CoordT*& zcorns) const;
  void computePillarVertex(size_t zcornId, CoordT xyz[3]) const;
  int generate_cell_vertices(size_t /*i*/,size_t /*j*/,size_t /*k*/,CoordT /*xyz*/[24], const size_t /*reindex*/[2][2][2]) const { return 0; }
  CoordT get_property(size_t i,size_t j,size_t k) const;
  CoordT get_zcorn(size_t i,size_t j,size_t k) const;
  CoordT get_porosity(size_t i, size_t j, size_t k) const;
  bool isValid(size_t i,size_t j,size_t k) const;
  void pushBackEGridZCorn(CoordT zcorn);
  void pushBackEGridPoro(float poro);
  void pushBackEGridActNum(ActiveT actnum);

  

  // return the corresponding zcorn index in the next upper cell face along the same pillar
  size_t getNextUpperCellFaceZCornId(size_t zcornId) const { return zcornId + m_numCorners; }
  // return the corresponding next upper face zcorn index along the same pillar in a given cell
  size_t getNextUpperFaceZCornId(size_t lowerFaceZCornId) const { return lowerFaceZCornId + m_upperFaceZCornIdShift; }

private:

  void setDim(size_t numCellI, size_t numCellJ, size_t numCellK);
  void setEGridZCorn(size_t eGridZcornId, CoordT zcorn);
  void setEGridPoro(size_t m_numPoroAdded, float poro);
  void setEGridActNum(size_t m_numActNumAdded, ActiveT actnum);

  // Size of the mesh 
  size_t m_4DimIDimJ;
  size_t m_2DimI;

  size_t computeZCornId(size_t i,size_t j,size_t k) const;

  size_t m_numCorners;         // number of vertices at each pillar level
  size_t m_upperFaceZCornIdShift; // gap between a lower face zcorn index and a upper face zcorn id 
                                  // belonging to the same pillar in the same cell 
  size_t m_numPillarVertices; // number of vertices on a each pillar
  size_t m_numPillarSliceIVertices; // number of vertices on a slice of pillar along the I-Dimension

  size_t m_numZcornAdded;
  size_t m_numPoroAdded;
  size_t m_numActNumAdded;
};

inline bool  
PillarGridJIK::isValid(size_t i,size_t j,size_t k) const 
{
  return Grid::isValid((j*m_iDim*m_kDim)+i*m_kDim+k);
}

inline size_t  
PillarGridJIK::computeZCornId(size_t i,size_t j,size_t k) const 
{
  return j*m_numPillarSliceIVertices + i*m_numPillarVertices + m_numCorners*k;
}


inline CoordT
PillarGridJIK::get_zcorn(size_t i, size_t j, size_t k) const
{
  return m_zcorn[computeZCornId(i,j,k)];
}

inline CoordT
PillarGridJIK::get_porosity(size_t i, size_t j, size_t k) const
{
  size_t poro_index = (j*m_iDim*m_kDim)+i*m_kDim+k;
  return m_poro[poro_index];
}
#endif


