#ifndef _SCL_SECURE_NO_WARNINGS // remove warning C4996: 'std::_Fill_n':
#define _SCL_SECURE_NO_WARNINGS
#include <algorithm>
#undef _SCL_SECURE_NO_WARNINGS
#endif

#include <cstdio>
#include <fstream>

#include "PillarGridReader.h"

#include <Inventor/SbElapsedTime.h> 
#include <Inventor/helpers/SbFileHelper.h>


PillarGridReader::PillarGridReader(): m_numZcornAdded(0), m_block_size (1000)
{
}

void display_time(const std::string &what, double timeElapsed);

char* 
PillarGridReader::getLine() 
{
  int goOn=1;
  char* p = fgets(m_Line,1024,fp);
  while (goOn && p) 
  {
    m_LineNumber++;
    goOn=0;
    if (CompareKeyword("--")) 
    {
      p = fgets(m_Line,1024,fp);
      goOn=1;
    }
    if (p[0]==10) 
    {
      p = fgets(m_Line,1024,fp);
      goOn=1;
    }
  }
  return(p);
}

int 
PillarGridReader::CompareKeyword(const char* keyword)
{
  size_t length=strlen(keyword);
  int res = strncmp(m_Line,keyword,length);
  return(res==0);
}

int 
PillarGridReader::ReadFloats(size_t nfloats,CoordT* farray,CoordT undef,int& res_err,size_t& nfloats_read)
{
  char seps[]= " \t\n";
  char* token;
  char* splittoken;
  float f1;
  int nf;
  int res;
  nfloats_read=0;
  res_err=1;

  char* p = getLine();
  m_LineNumber++;
  if (!p) 
  {
    res_err = -1;
    return 0;
  }

  int goOn=1;
  while (goOn) 
  {
    token = strtok(m_Line,seps);
    if (!token) goOn=0;
    while ( (token != NULL) && goOn ) 
    {
      nf = 1;
      if ( (splittoken = strchr(token,'*')) )
      {
        sscanf(token,"%d",&nf);
        res = sscanf(splittoken+1,"%f",&f1);
      }
      else
        res = sscanf(token,"%f",&f1);

      if (res==1)
      {
        std::fill_n(farray+nfloats_read,nf,(CoordT)f1);
        nfloats_read+=nf;
      }
      else
      {
        //check if reach end of record or just wrong coords
        if (token[0]=='/') 
          goOn=0;
        else 
        { //dummy float
          std::fill_n(farray+nfloats_read,nf,undef);
          printf("warning: dummy float\n");
          nfloats_read+=nf; 
        }	
      }
      if (nfloats_read>nfloats) 
      {
        printf("warning: too many floats\n");
        goOn=0;
      }
      token = strtok(NULL,seps);
    }
    if (goOn) 
    {
      p = getLine();
      m_LineNumber++;
    }
  }

  printf("ReadFloats gets %llu of %llu\n",static_cast<unsigned long long>(nfloats_read), static_cast<unsigned long long>(nfloats));
  if ( nfloats_read < nfloats )
  {
    printf("error: not enough floats\n");
    res_err = -1;
    return 0;
  }
  else
    return 1;
}

int 
PillarGridReader::ReadBytes(size_t nbytes,std::vector<ActiveT>& barray,int& res_err,size_t& nbytes_read)
{
  char seps[]= " \t\n";
  char* token;
  char* splittoken;
  int d1;
  int nb;
  int res;
  nbytes_read=0;
  res_err=1;

  char* p = getLine();
  m_LineNumber++;
  if (!p) 
  {
    res_err = -1;
    return 0;
  }

  int goOn=1;
  while (goOn) 
  {
    token = strtok(m_Line,seps);
    if (!token) goOn=0;
    while ( (token != NULL) && goOn ) 
    {
      nb = 1;
      if ( (splittoken = strchr(token,'*')) )
      {
        sscanf(token,"%d",&nb);
        res = sscanf(splittoken+1,"%d",&d1);
      } 
      else 
        res = sscanf(token,"%d",&d1);

      if (res==1)
      {
        std::fill_n(barray.begin()+nbytes_read,nb,(d1==1));
        nbytes_read+=nb;
      }
      else
      {
        //check if reach end of record or just wrong coords
        if (token[0]=='/') 
          goOn=0;
        else
        { //dummy float
          std::fill_n(barray.begin()+nbytes_read,nb,false);
          printf("warning: dummy bytes\n");
          nbytes_read+=nb; 
        }
      }
      if (nbytes_read>nbytes)
      {
        printf("warning: too many bytes\n");
        goOn=0;
      }
      token = strtok(NULL,seps);
    }
    if (goOn) 
    {
      p = getLine();
      m_LineNumber++;
    }
  }

  printf("ReadBytes gets %llu of %llu\n",static_cast<unsigned long long >(nbytes_read), static_cast<unsigned long long >(nbytes));
  if ( nbytes_read < nbytes )
  {
    printf("error: not enough bytes\n");
    res_err = -1;
    return 0;
  }
  else
    return 1;
}


int 
PillarGridReader::ReadSpecGrid(PillarGrid& pillarGrid)
{
  printf("read SPECGRID\n");

  char* p = getLine();
  if (!p) 
  {
    m_SpecGrid_res = -1;
    return 0;
  }
  int ni,nj,nk;

  int res = sscanf(m_Line,"%d %d %d",&ni,&nj,&nk);
  if (res!=3)
  {
    m_SpecGrid_res = -2;
    return 0;
  }

  pillarGrid.setDim(ni,nj,nk);

  m_SpecGrid_res = 1;

  return 1;
}

int 
PillarGridReader::ReadCoord(PillarGrid& pillarGrid)
{
  size_t npillars = (pillarGrid.m_iDim+1) * (pillarGrid.m_jDim+1);
  size_t nfloats = 6 * npillars;
  size_t nfloats_read;
  printf("read COORD\n");
  int res = ReadFloats(nfloats,&pillarGrid.m_coord[0],pillarGrid.m_undef,m_Coord_res,nfloats_read);
  return res;
}

int 
PillarGridReader::ReadZCorn(PillarEGrid& pillarGrid)
{
  size_t nfloats = 8 * pillarGrid.m_iDim * pillarGrid.m_jDim * pillarGrid.m_kDim;
  size_t nfloats_read;
  printf("read ZCORN\n");
  int res = ReadFloats(nfloats,&pillarGrid.m_zcorn[0],pillarGrid.m_undef,m_ZCorn_res,nfloats_read);
  return res;

}

int 
PillarGridReader::ReadZCorn(PillarGridJIK& pillarGrid)
{
  size_t nfloats = 8 * pillarGrid.m_iDim * pillarGrid.m_jDim * pillarGrid.m_kDim;
  size_t nfloats_read;
  std::vector<CoordT> temp; 
  temp.resize(nfloats);
  printf("read ZCORN\n");
  int res = ReadFloats(nfloats,&temp[0],pillarGrid.m_undef,m_ZCorn_res,nfloats_read);
  for (size_t i = 0; i<nfloats; ++i)
    pillarGrid.pushBackEGridZCorn(temp[i]);
  return res;

}

int 
PillarGridReader::ReadActnum(PillarEGrid& pillarGrid)
{
  size_t nbytes = pillarGrid.m_iDim * pillarGrid.m_jDim * pillarGrid.m_kDim;
  size_t nbytes_read;

  printf("read ACTNUM\n");
  int res = ReadBytes(nbytes,pillarGrid.m_actnum,m_Actnum_res,nbytes_read);

  for (size_t i = 0; i< pillarGrid.m_actnum.size(); ++i)
    if (pillarGrid.m_actnum[i] == 0) 
      ++pillarGrid.m_numNonActiveCells;

  return res;
}

int 
PillarGridReader::ReadActnum(PillarGridJIK& pillarGrid)
{
  size_t nfloats = pillarGrid.m_iDim * pillarGrid.m_jDim * pillarGrid.m_kDim;
  size_t nfloats_read;
  std::vector<CoordT> temp; 

  printf("read ACTNUM\n");
  temp.resize(nfloats);
  int res = ReadFloats(nfloats,&temp[0],pillarGrid.m_undef,m_Actnum_res,nfloats_read);
  for (size_t i = 0; i<nfloats; ++i)
  {
    pillarGrid.pushBackEGridActNum((ActiveT)temp[i]);
    if (pillarGrid.m_actnum[i] == 0) {++pillarGrid.m_numNonActiveCells;}
  }
  return res;
}

int PillarGridReader::ReadPoro(PillarEGrid& pillarGrid)
{
  size_t nfloats =  pillarGrid.m_iDim * pillarGrid.m_jDim * pillarGrid.m_kDim;
  size_t nfloats_read;

  printf("read PORO\n");
  pillarGrid.m_poro.resize (nfloats);
  int res = ReadFloats(nfloats,&pillarGrid.m_poro[0],pillarGrid.m_undef,m_Poro_res,nfloats_read);

  return res;
}

int 
PillarGridReader::ReadPoro(PillarGridJIK& pillarGrid)
{
  size_t nfloats = pillarGrid.m_iDim * pillarGrid.m_jDim * pillarGrid.m_kDim;
  size_t nfloats_read;
  std::vector<CoordT> temp; 

  printf("read PORO\n");

  temp.resize(nfloats);
  pillarGrid.m_poro.resize (nfloats);
  int res = ReadFloats(nfloats,&temp[0],pillarGrid.m_undef,m_Poro_res,nfloats_read);
  for (size_t i = 0; i<nfloats; ++i)
    pillarGrid.pushBackEGridPoro(temp[i]);
  return res;
}

void 
PillarGridReader::read(PillarGrid& pillarGrid, const std::string& filename) 
{
  pillarGrid.clear();

  SbElapsedTime localTime;
  double t1 = localTime.getElapsed();
  fp = SbFileHelper::open( filename.c_str() , "r" );

  int res = 1;

  m_LineNumber = 0;

  m_SpecGrid_res = 0;
  m_Coord_res = 0;
  m_ZCorn_res = 0;
  m_Actnum_res = 0;
  m_Poro_res = 0;

  while (!feof(fp) && res>0) 
  {
    getLine();
    m_LineNumber++;

    if (CompareKeyword("SPECGRID")) 
      res = ReadSpecGrid(pillarGrid);
    if (CompareKeyword("COORDSYS")) 
      ;
    else 
      if (CompareKeyword("COORD"))
        res = ReadCoord(pillarGrid);
    if (CompareKeyword("ZCORN")) 
      res = ReadZCorn(pillarGrid);
    if (CompareKeyword("ACTNUM")) 
      res = ReadActnum(pillarGrid);
    if (CompareKeyword("PORO")) 
      res = ReadPoro(pillarGrid);
  }

  pillarGrid.updateMinMax();

  double t1bis = localTime.getElapsed();

  if( m_SpecGrid_res==0 || m_Coord_res==0 || m_ZCorn_res==0)
  {
    std::cout<< "PillarGridReader: file format not supported" << std::endl;
    pillarGrid.clear();
  }
  else if( res > 0 )
    display_time("File read",t1bis-t1);
  else
    pillarGrid.clear();

  fclose(fp);

}
