#ifndef _PillarGridReader_H
#define _PillarGridReader_H

#define EPSILON 0.001
#define READBINARY 1
#define GENERATEMASK 1
#include "PillarGrid.h"

#include <Inventor/STL/string>

class PillarGridReader 
{

public:
  PillarGridReader();
	void read(PillarGrid& pillarGrid, const std::string& filename);
  bool read_zcorns_data(std::istream& is, PillarGridJIK& grid, const std::size_t& size);

private:

	int ReadSpecGrid(PillarGrid& pillarGrid);
	int ReadCoord(PillarGrid& pillarGrid);
	int ReadZCorn(PillarEGrid& pillarGrid);
  int ReadZCorn(PillarGridJIK& pillarGrid);
	int ReadActnum(PillarEGrid& pillarGrid);
  int ReadActnum(PillarGridJIK& pillarGrid);
	int ReadPoro(PillarEGrid& pillarGrid);
  int ReadPoro(PillarGridJIK& pillarGrid);
  size_t m_numZcornAdded;

	int ReadFloats(size_t nfloats,CoordT* farray,CoordT undef,int& res_err,size_t& nfloats_read);
	int ReadBytes(size_t nbytes,std::vector<ActiveT>& barray,int& res_err,size_t& nbytes_read);

	char* getLine();
  int CompareKeyword(const char* keyword);

	int m_SpecGrid_res;
	int m_Coord_res;
	int m_ZCorn_res;
	int m_Actnum_res;
	int m_Poro_res;
  const size_t m_block_size; 

	int m_LineNumber;
	char m_Line[1024];
	FILE* fp;
};

#endif


