#include "MeshResolutionSwitch.h"

#include <Inventor/sensors/SoAlarmSensor.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/SbTime.h>

void 
MeshResolutionSwitch::restoreToFullResolution(void* meshResolutionSwitch, SoSensor*) 
{
  ((MeshResolutionSwitch*)meshResolutionSwitch)->switchToFullResolution();
}


MeshResolutionSwitch::MeshResolutionSwitch() :
  m_delayToFullResolution(5),
  m_fullResolutionSchedulingEnabled(false)
{
  m_sensor = new SoAlarmSensor(restoreToFullResolution, (void*)this);
}



MeshResolutionSwitch::~MeshResolutionSwitch()
{
  delete m_sensor;
}

void 
MeshResolutionSwitch::setFullResolutionSceneGraph(SoNode* fullResolutionSceneGraph)
{
  this->insertChild(fullResolutionSceneGraph,0);
}

void 
MeshResolutionSwitch::setLowResolutionSceneGraph(SoNode* lowResolutionSceneGraph)
{
  this->insertChild(lowResolutionSceneGraph,1);
}

void 
MeshResolutionSwitch::setFullResolutionDelay(int delay)
{
  m_delayToFullResolution = delay;
}

void 
MeshResolutionSwitch::switchToLowResolution()
{
  if (this->whichChild.getValue() == 0) 
    this->whichChild = 1;
  scheduleFullResolution();
}

void 
MeshResolutionSwitch::switchToFullResolution()
{
  if (this->whichChild.getValue() != 0) 
  {
    this->whichChild = 0;
    m_sensor->unschedule();
    fullResolutionIsBack();
  }
}

void 
MeshResolutionSwitch::scheduleFullResolution()
{
  m_sensor->unschedule();
  if (m_fullResolutionSchedulingEnabled) 
  {
    // schedule sensor to restore full resolution only if FullResolutionScheduling is enabled
    m_sensor->setTimeFromNow(SbTime((double)m_delayToFullResolution));
    m_sensor->schedule();
  }
}

void  
MeshResolutionSwitch::enableFullResolutionScheduling(bool active)
{
  m_fullResolutionSchedulingEnabled = active;
  scheduleFullResolution();
}

bool
MeshResolutionSwitch::lowResolutionEnabled() const
{
  return (this->whichChild.getValue() == 1);
}
