#include "AnimatedPillarPorosity.h"

const double AnimatedPillarPorosity::TWO_PI = (2.0 * 3.1415927);

AnimatedPillarPorosity::AnimatedPillarPorosity(const PillarGrid& grid)
    : PillarPorosity(grid), m_frame(0)
{
  int i;
  for (i = 0; i < NUM_FRAMES; i++)
    m_unit_sin_table[i] = -1.0;
  m_range = ((getMax() - getMin()) / 10);
}

void
AnimatedPillarPorosity::setFrame(int frame) 
{
  if (m_frame != frame)
  {
    m_frame = frame;
    if (m_unit_sin_table[m_frame] < 0.0) 
      m_unit_sin_table[m_frame] = sin(TWO_PI * ((double)m_frame / 100.0));
    touch();
  }
}


double
AnimatedPillarPorosity::get(size_t i, size_t j, size_t k) const
{
  double original_val = PillarPorosity::get((int)i, (int)j, (int)k);

  if (m_frame == 0)
    return original_val;

  double unit = m_unit_sin_table[m_frame]; 
  double halfI = double(m_grid.get_dimI()/2);
  double halfJ = double(m_grid.get_dimJ()/2);
  return original_val + 0.02*unit*(i/halfI)+ 0.02*unit*(j/halfJ);
}
