
#include "AnimatedPillarProperty.h"

const double AnimatedPillarProperty::TWO_PI = (2.0 * 3.1415927);

AnimatedPillarProperty::AnimatedPillarProperty(const PillarGrid& grid)
    : PillarProperty(grid), m_frame(0)
{
  int i;

  for (i = 0; i < NUM_FRAMES; i++)
  {
    m_unit_sin_table[i] = -1.0;
  }

  m_scale = ((getMax() - getMin()) / 2.0) / sqrt(pow((double)m_grid.get_dimI(), 2) + pow((double)m_grid.get_dimJ(), 2));

  m_half_i_range = ((double)m_grid.get_dimI()) / 2.0;
  m_half_j_range = ((double)m_grid.get_dimJ()) / 2.0;
}

void
AnimatedPillarProperty::setFrame(int frame) 
{  
  if (m_frame != frame)
  {
    m_frame = frame;
    touch();
  }
}

double
AnimatedPillarProperty::get(size_t i, size_t j, size_t k) const
{
  double original_val = PillarProperty::get((int)i, (int)j, (int)k);

  if (m_frame == 0)
  {
    return original_val;
  }

  if (m_unit_sin_table[m_frame] < 0.0) {
    m_unit_sin_table[m_frame] = sin(TWO_PI * ((double)m_frame / 100.0));
  }
  double unit_sin_frame = m_unit_sin_table[m_frame];

  return original_val + (unit_sin_frame * (((double)((i - m_half_i_range) + (j - m_half_j_range))) * m_scale * 0.35));
}

