#ifndef _AnimatedPillarPropertyIjk_H_
#define _AnimatedPillarPropertyIjk_H_

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#endif

#include "PillarProperty.h"

class AnimatedPillarProperty : public PillarProperty
{
public:
  AnimatedPillarProperty(const PillarGrid& grid);

  double get(size_t i, size_t j, size_t k) const;
  void setFrame(int frame);

protected:
  int m_frame;

  static const int NUM_FRAMES = 100;
  static const double TWO_PI;

  mutable double m_unit_sin_table[NUM_FRAMES];

  double m_scale;

  double m_half_i_range;
  double m_half_j_range;
};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


