#ifndef  _CachedPillarTopology_H
#define  _CachedPillarTopology_H

#include "PillarTopology.h"
#include "pillargrid/PillarGrid.h"

class CachedPillarGeometry;

class CachedPillarTopology : public PillarTopology<PillarGrid>
{
public:
  CachedPillarTopology(const PillarGrid& grid, CachedPillarGeometry& geometry);

  /**
  * Returns the number of cells on the second logical axis.
  */
  size_t getNumCellsJ() const { return m_numJ; }

  /**
  * Returns 8 indices of a cell of this topology. The cell 
  * is identified by three id i,j,k.
  */
  virtual void getCellNodeIndices(size_t i, size_t j, size_t k, size_t& n0, size_t& n1, size_t& n2, size_t& n3,
                                                                size_t& n4, size_t& n5, size_t& n6, size_t& n7) const;

  size_t getEndNodeId() const;

  virtual size_t getMemoryFootPrint() const { return sizeof(NodeIdT) * m_indices.size(); }

private:
  void init();
  void generateCellNodeIndices(const PillarEGrid& grid, CachedPillarGeometry& geometry);
  void generateCellNodeIndices(const PillarGridJIK& grid, CachedPillarGeometry& geometry);

  std::vector<NodeIdT> m_indices;
  size_t m_endNodeId;
  size_t m_numJ;
  size_t m_numK;
  size_t m_numKxI;
  int m_next_direction[8];
};

#endif







