#include <cstdio>
#include <Inventor/STL/string>
#include <MeshVizXLM/extractors/MiPerCellToPerNodeExtractHexahedronIjk.h>

#include "DemoSettings.h"
#include "CachedTopoPillarMesh.h"
#include "IndexedPillarGeometry.h"
#include "CachedPillarTopology.h"
#include <Inventor/SbElapsedTime.h> 

void display_time(const std::string &what, double timeElapsed);

CachedTopoPillarMesh::CachedTopoPillarMesh(PillarGrid& grid) 
: IndexedPillarMesh(grid,new IndexedPillarGeometry(grid),"Cached Topology PillarMesh")
{
  generateMesh(grid);
}

CachedTopoPillarMesh::CachedTopoPillarMesh(PillarGrid& grid, CachedPillarGeometry* geometry, std::string name) 
: IndexedPillarMesh(grid,geometry,name)
{
  generateMesh(grid);
}

void
CachedTopoPillarMesh::generateMesh(const PillarGrid& grid)
{
  SbElapsedTime localTime;
  double t1 = localTime.getElapsed();

  m_topology = new CachedPillarTopology(grid,(CachedPillarGeometry&)*m_geometry);

  double t2 = localTime.getElapsed();
  display_time(m_name+" created",t2-t1);
}
