#include "CellFilter.h"
#include "EclipseMesh.h"

// ROIDataRangeFilter Class
CellFilter::CellFilter()
  : m_imin( 0 )
  , m_imax( 0 )
  , m_jmin( 0 )
  , m_jmax( 0 )
  , m_kmin( 0 )
  , m_kmax( 0 )
  , m_origimin( 0 )
  , m_origimax( 0 )
  , m_origjmin( 0 )
  , m_origjmax( 0 )
  , m_origkmin( 0 )
  , m_origkmax( 0 )
  , m_dataUndef( 0 )
  , m_dataMin( 0 )
  , m_dataMax( 0 )
  , m_Mesh( NULL )
  , m_dataSet(NULL)
  , m_timeStamp( 0 )
  , m_reverse( false )
{
}

CellFilter::~CellFilter()
{
}

bool 
CellFilter::acceptCell(size_t i, size_t j, size_t k) const
{
  return (i>=m_imin && i<=m_imax && j>=m_jmin && j<=m_jmax && k>=m_kmin && k<=m_kmax ) &&
    (m_dataMin <= m_dataSet->get(i, j, k) && m_dataSet->get(i, j, k) <= m_dataMax) ^ m_reverse;
}

void 
CellFilter::setMesh(const EclipseMesh* mesh)
{
  m_Mesh = mesh;
  if (m_Mesh)
  {
    size_t ni = m_Mesh->getDimI();

    getROI(m_imin,m_imax,m_jmin,m_jmax,m_kmin,m_kmax);

    if ( ni != m_Mesh->getTopology().getNumCellsI() )
      m_factor = ni / (double) m_Mesh->getTopology().getNumCellsI();
    else
      m_factor = 1.0;

    setROI(m_imin,m_imax,m_jmin,m_jmax,m_kmin,m_kmax);
  }
  else
    setROI(0,0,0,0,0,0);

  ++m_timeStamp;
}

bool
CellFilter::isActive() const
{
  return m_Mesh != NULL && m_dataSet != NULL && (m_origimin > 0 || m_origjmin > 0 || m_origkmin > 0 ||
    m_origimax+1 < m_Mesh->getDimI() || m_origjmax+1 < m_Mesh->getDimJ() || m_origkmax+1 < m_Mesh->getDimK() ||
    m_dataMin > m_dataSet->getMin() || m_dataMax < m_dataSet->getMax());
}

void 
CellFilter::setROI(size_t imin,size_t imax,size_t jmin,size_t jmax,size_t kmin,size_t kmax)
{
  m_origimin = imin;
  m_origimax = imax;
  m_origjmin = jmin;
  m_origjmax = jmax;
  m_origkmin = kmin;
  m_origkmax = kmax;

  m_imin = int(imin / m_factor);
  m_imax = int(imax / m_factor);
  m_jmin = int(jmin / m_factor);
  m_jmax = int(jmax / m_factor);
  m_kmin = int(kmin / m_factor);
  m_kmax = int(kmax / m_factor);
  ++m_timeStamp;
}

void 
CellFilter::getROI(size_t& imin,size_t& imax,size_t& jmin,size_t& jmax,size_t& kmin,size_t& kmax) const
{
  imin = m_origimin;
  imax = m_origimax;
  jmin = m_origjmin;
  jmax = m_origjmax;
  kmin = m_origkmin;
  kmax = m_origkmax;
}

void 
CellFilter::setDataUndef(float undef)
{
  m_dataUndef=undef;
  ++m_timeStamp;
}

void 
CellFilter::setDataRange(double min, double max)
{
  m_dataMin=min;
  m_dataMax=max;
  ++m_timeStamp;
}

void 
CellFilter::getDataRange(double& min, double& max) const
{
  min=m_dataMin;
  max=m_dataMax;
}

void 
CellFilter::setReverse(bool reverse) const
{
  m_reverse = reverse;
}





