#ifndef _ROIDATARANGEFILTER_H_
#define _ROIDATARANGEFILTER_H_

#include <MeshVizXLM/mesh/cell/MiCellFilterIjk.h>
#include <vector>

#include "GridPropertyIjk.h"

class EclipseMesh;


class CellFilter : public MiCellFilterIjk
{

public :

  CellFilter();
  ~CellFilter();

  // from MiCellFilterIjk
  bool acceptCell(size_t i, size_t j, size_t k) const;
  size_t getTimeStamp() const { return m_timeStamp; }
  void touch() { ++m_timeStamp; }
  bool isActive() const;

  void setMesh(const EclipseMesh* mesh);
  void setDataSet( const GridPropertyIjk* dataset ) { m_dataSet = dataset; }

  void setROI(size_t imin,size_t imax,size_t jmin,size_t jmax,size_t kmin,size_t kmax);
  void getROI(size_t& imin,size_t& imax,size_t& jmin,size_t& jmax,size_t& kmin,size_t& kmax) const;

  void setDataUndef(float undef);
  void setDataRange(double min,double max);
  void getDataRange(double& min,double& max) const;

  void setReverse(bool reverse) const;

protected:
	size_t m_imin;
	size_t m_imax;
	size_t m_jmin;
	size_t m_jmax;
	size_t m_kmin;
	size_t m_kmax;

	size_t m_origimin;
	size_t m_origimax;
	size_t m_origjmin;
	size_t m_origjmax;
	size_t m_origkmin;
	size_t m_origkmax;

	float m_dataUndef;
	double m_dataMin;
	double m_dataMax;
	const EclipseMesh* m_Mesh;
  const GridPropertyIjk* m_dataSet;
  size_t m_timeStamp;

  double m_factor;

  mutable bool m_reverse; 

};


#endif


