#ifndef _EclipseMeshIjk_H_
#define _EclipseMeshIjk_H_

#include <MeshVizXLM/mesh/MiMeshIjk.h>
#include <MeshVizXLM/MbVec3.h>

#include "GridPropertyIjk.h"

class EclipseMesh : virtual public MiMeshIjk
{
public:
  EclipseMesh(size_t numI, size_t numJ, size_t numK) :  m_numCellI(numI), m_numCellJ(numJ), m_numCellK(numK) 
  {
  }

  /* 
  * Computes bounding box center 
  */
  virtual MbVec3f getCenter() const = 0;
  virtual MbVec3f getBBSize() const = 0;
  const GridPropertyIjk* getProperty(const std::string& propertyName) const
  {
    if (propertyName == "Depth")
      return &this->getDepth();
    else if(propertyName == "Porosity")
      return &this->getPorosity();
    else
      return NULL;
  }
  virtual const GridPropertyIjk& getDepth() const = 0;
  virtual const GridPropertyIjk& getPorosity() const = 0;
  virtual void setFrame(int /*frame*/,bool /*updatePerNode*/) {}

  // Size of the mesh 
  size_t getDimI() const { return m_numCellI; }
  size_t getDimJ() const { return m_numCellJ; }
  size_t getDimK() const { return m_numCellK; }

private:   // Pillar grid dimension (these dimensions can differ from the topology dimension in low resolution mesh)
  size_t m_numCellI;
  size_t m_numCellJ;
  size_t m_numCellK;

};

#endif


