#include "IndexedPillarGeometry.h"
#include <Inventor/STL/algorithm>
#include <Inventor/STL/limits>


//-----------------------------------------------------------------------------
IndexedPillarGeometry::IndexedPillarGeometry(PillarGrid& grid) 
: CachedPillarGeometry(grid)
{
  m_zcornIndices.reserve((m_grid.get_dimI()+1)*(m_grid.get_dimJ()+1)*(m_grid.get_dimK()+1));
}

//-----------------------------------------------------------------------------
size_t IndexedPillarGeometry::size() const
{
  return m_zcornIndices.size();
}

//-----------------------------------------------------------------------------
size_t IndexedPillarGeometry::addPoint(NodeIdT pointIndex)
{
  m_zcornIndices.push_back(pointIndex);
  return m_zcornIndices.size() - 1;
}

//-----------------------------------------------------------------------------
MbVec3d IndexedPillarGeometry::getCoord(size_t id) const
{
  CoordT xyz[3];
  m_grid.computePillarVertex(m_zcornIndices[id],xyz);
  return MbVec3d(xyz);
}
