#ifndef  _IndexedPillarGeometry_H
#define  _IndexedPillarGeometry_H

#include <Inventor/STL/vector>
#include <MeshVizXLM/MxTimeStamp.h>
#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>

#include "wrappers/CachedPillarGeometry.h"
#include "pillargrid/PillarGrid.h"

class IndexedPillarGeometry : public CachedPillarGeometry
{
public:
  IndexedPillarGeometry(PillarGrid& grid);

  MbVec3d getCoord(size_t id) const;
  size_t addPoint(NodeIdT zcornIndex);
  size_t size() const;

  virtual size_t getMemoryFootPrint() const { return sizeof(NodeIdT) * m_zcornIndices.size(); }

private:
  // table to map topology indices into the grid
  // avoid extra large geometry due to grid indices (up to 8*ni*nj*nk) 
  std::vector<NodeIdT> m_zcornIndices;

};

#endif







