#include <cstdio>
#include <Inventor/STL/string>

#include "DemoSettings.h"
#include "IndexedPillarMesh.h"
#include "PillarGeometry.h"
#include "PillarTopology.h"
#include <Inventor/SbElapsedTime.h> 

void 
display_time(const std::string &what, double timeElapsed);

IndexedPillarMesh::IndexedPillarMesh(PillarGrid& grid, std::string name) 
  : PillarMesh(grid,name)
{
  SbElapsedTime localTime;
  double t1 = localTime.getElapsed();

  m_geometry = new PillarGeometry(grid);
  m_topology = new PillarTopology<PillarGrid>(grid);

  double t2 = localTime.getElapsed();
  display_time(m_name+" created",t2-t1);
}

IndexedPillarMesh::IndexedPillarMesh(PillarGrid& grid, PillarGeometry* geometry, std::string name) 
: PillarMesh(grid,name), m_geometry(geometry)
{
}

IndexedPillarMesh::~IndexedPillarMesh()
{
  delete m_topology;
  delete m_geometry;
}


