#ifndef _IndexedPillarMesh_H_
#define _IndexedPillarMesh_H_

#include <MeshVizXLM/mesh/MiVolumeMeshHexahedronIjk.h>
#include "PillarMesh.h"
#include "PillarTopology.h"
#include "PillarGeometry.h"
#include "AnimatedPillarProperty.h"
#include "PillarPorosity.h"
#include "AnimatedPillarPorosity.h"

class IndexedPillarMesh : public PillarMesh, virtual public MiVolumeMeshHexahedronIjk
{
public:
  IndexedPillarMesh(PillarGrid& grid, std::string name = "Indexed PillarMesh");
  ~IndexedPillarMesh();
  
  /**
  * Returns the topology of this mesh.
  */
  const PillarTopology<PillarGrid>& getTopology() const
  {
    return *m_topology;
  }

  /**
  * Returns the unstructured geometry of this mesh. 
  */
  const PillarGeometry& getGeometry() const 
  { 
    return *m_geometry; 
  }

  /*
  * Computes bounding box center 
  */
  MbVec3f getCenter() const
  {
    return MbVec3f(m_geometry->getMin() + m_geometry->getMax())/2.0f;
  }

  MbVec3f getBBSize() const
  {
    return MbVec3f(m_geometry->getMax() - m_geometry->getMin());
  }

  size_t getMemoryFootPrint() const { return m_topology->getMemoryFootPrint() + m_geometry->getMemoryFootPrint(); }

protected:
  IndexedPillarMesh(PillarGrid& grid, PillarGeometry* geometry, std::string name);

  PillarTopology<PillarGrid>* m_topology;
  PillarGeometry* m_geometry;

private:
  void generateMesh(const PillarGrid& grid);

};


#endif


