#include "PillarGeometry.h"
#include <MeshVizXLM/MxTimeStamp.h>

//-----------------------------------------------------------------------------
PillarGeometry::PillarGeometry(PillarGrid& grid) 
: m_grid(grid), m_timeStamp(MxTimeStamp::getTimeStamp()) 
{
  grid.getMinMax(&m_min[0],&m_max[0]);
}

//-----------------------------------------------------------------------------
size_t PillarGeometry::size() const
{
  return m_grid.getNumZCorns();
}

//-----------------------------------------------------------------------------
MbVec3d PillarGeometry::getCoord(size_t id) const
{
  CoordT xyz[3];
  m_grid.computePillarVertex(id,xyz);
  return MbVec3d(xyz);
}

//-----------------------------------------------------------------------------
MbVec3d
PillarGeometry::getMin() const
{
  return (MbVec3d) m_min;
}

//-----------------------------------------------------------------------------
MbVec3d
PillarGeometry::getMax() const
{
  return (MbVec3d) m_max;
}

