#ifndef  _PillarGeometry_H
#define  _PillarGeometry_H

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>

#include "pillargrid/PillarGrid.h"

class PillarGeometry : public MiGeometryI
{
public:
  PillarGeometry(PillarGrid& grid);

  size_t getTimeStamp() const { return m_timeStamp; }

  virtual MbVec3d getMin() const;
  virtual MbVec3d getMax() const;

  // the given id is a zcorn index in the zcorn table of the pillar grid
  MbVec3d getCoord(size_t id) const;
  virtual size_t size() const;

  virtual size_t getMemoryFootPrint() const {return 0;}

protected:
  const PillarGrid& m_grid;

private:
  size_t m_timeStamp;
  MbVec3<CoordT> m_min, m_max;

};

#endif







