#include <cstdio>
#include <Inventor/STL/string>
#include <MeshVizXLM/extractors/MiPerCellToPerNodeExtractHexahedronIjk.h>

#include "DemoSettings.h"
#include "PillarMesh.h"
#include <Inventor/SbElapsedTime.h> 

void 
display_time(const std::string &what, double timeElapsed);

PillarMesh::PillarMesh( const PillarGrid& grid, std::string name )
  : EclipseMesh(grid.get_dimI(),grid.get_dimJ(),grid.get_dimK()), m_name(name), m_depth(grid), m_porosity(grid), m_grid(grid)
{
}

PillarMesh::~PillarMesh()
{
}

AnimatedPillarProperty&
PillarMesh::getDepth()  
{
  return m_depth;
}

const GridPropertyIjk&
PillarMesh::getDepth() const
{
  return m_depth;
}

AnimatedPillarPorosity& 
PillarMesh::getPorosity()
{
	return m_porosity;
}

const GridPropertyIjk&
PillarMesh::getPorosity() const
{
  return m_porosity;
}


