#ifndef _PillarMesh_H_
#define _PillarMesh_H_

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include "EclipseMesh.h"
#include "PillarTopology.h"
#include "PillarGeometry.h"
#include "AnimatedPillarProperty.h"
#include "PillarPorosity.h"
#include "AnimatedPillarPorosity.h"

class MiPerCellToPerNodeExtractHexahedronIjk;
class MiExtractorCallback;

class PillarMesh : public EclipseMesh
{
public:
  ~PillarMesh();
  
  /*
  * return data set
  */
  const GridPropertyIjk& getDepth() const;
  const GridPropertyIjk& getPorosity() const;

  AnimatedPillarPorosity& getPorosity();

  AnimatedPillarProperty& getDepth() ;

  // pass through current animation frame to dataset
  void setFrame(int frame) 
  { 
    m_depth.setFrame(frame);
      m_porosity.setFrame(frame);
  }

  virtual size_t getMemoryFootPrint() const { return 0; }
  size_t getNumActiveCells() const;

protected:
  PillarMesh(const PillarGrid& grid, std::string name);

  std::string m_name;

private:
  void generateMesh(const PillarGrid& grid);

  AnimatedPillarProperty m_depth;
  AnimatedPillarPorosity m_porosity;
  const PillarGrid& m_grid;
};

//-----------------------------------------------------------------------------
inline size_t
PillarMesh::getNumActiveCells() const
{
  return m_grid.get_dimI()*m_grid.get_dimJ()*m_grid.get_dimK() - m_grid.getNumNonActiveCells();
}


#endif


