#include "PillarPorosity.h"

PillarPorosity::PillarPorosity (const PillarGrid& grid) : PillarProperty(grid, "PillarPorosity")
{
   m_min = initMin();
   m_max = initMax();
};

 double
 PillarPorosity::initMin() const 
 {
	float minPorosity = std::numeric_limits<float>::max();
	for (int i = 0; i < (int) m_grid.porositySize(); ++i){
		if ( m_grid.getPoro(i) < minPorosity) minPorosity = m_grid.getPoro(i);
	}
	return minPorosity;
}

 double 
 PillarPorosity::initMax() const 
 {
	float maxPorosity = -std::numeric_limits<float>::max();;
	for (int i = 0; i < (int) m_grid.porositySize(); ++i){
		if ( m_grid.getPoro(i) > maxPorosity) maxPorosity = m_grid.getPoro(i);
	}
	return maxPorosity;
}

