#ifndef  _PillarPropertyPorosity_H
#define  _PillarPropertyPorosity_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#endif

#include "wrappers/PillarProperty.h"

class PillarPorosity : public PillarProperty
{
public:
  PillarPorosity(const PillarGrid& grid);

  virtual inline double get(size_t i, size_t j, size_t k) const
  {
    return (double) m_grid.get_porosity(i,j,k);
  }

  size_t getSize() const
  {
    return m_grid.porositySize();
  }

private:
  double initMin() const;
  double initMax() const;
};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif
