#ifndef  _PillarPropertyIjk_H
#define  _PillarPropertyIjk_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#endif

#include "GridPropertyIjk.h"
#include "pillargrid/PillarGrid.h"

class PillarProperty : public GridPropertyIjk
{
public:

  PillarProperty(const PillarProperty& source)
    : GridPropertyIjk("PillarProperty",MiDataSet::PER_CELL),
    m_grid(source.m_grid), 
    m_min(source.m_min), 
    m_max(source.m_max)
  {
  }

  PillarProperty(const PillarGrid& grid, const std::string& name = "PillarProperty")
    : GridPropertyIjk(name, MbDataSet::PER_CELL),
    m_grid(grid)
  {
    CoordT min[3], max[3];
    grid.getMinMax(min,max);
    m_min = min[2];
    m_max = max[2];
  }

  virtual double getMin() const;
  virtual double getMax() const;

  virtual double get(size_t i, size_t j, size_t k) const
  {
    return (double) m_grid.get_zcorn(i,j,k);
  }

protected:
  std::ostream& toStream(std::ostream& s) const
  {
    return MiScalardSetIjk::toStream(s);
  }

  const PillarGrid& m_grid;
  mutable double m_min, m_max;

};

//-----------------------------------------------------------------------------
inline double
PillarProperty::getMin() const
{
  return m_min;
}

//-----------------------------------------------------------------------------
inline double
PillarProperty::getMax() const
{
  return m_max;
}


#ifdef _WIN32
#pragma warning(pop)
#endif

#endif







