#include "SubSampledMesh.h"
#include <MeshVizXLM/extractors/MiPerCellToPerNodeExtractHexahedronIjk.h>

SubSampledMesh::SubSampledMesh(const IndexedPillarMesh& mesh, double ratio)
: EclipseMesh(mesh), m_step((size_t)(1/ratio)), m_fullResMesh(mesh),
m_topology(m_fullResMesh.getTopology(),m_step)
{
  m_depth = new SubSampledScalarSet(m_fullResMesh.getDepth(), mesh.getTopology().getNumCellsI(), mesh.getTopology().getNumCellsJ(), mesh.getTopology().getNumCellsK(), m_step);
  m_porosity = new SubSampledScalarSet(m_fullResMesh.getPorosity(), mesh.getTopology().getNumCellsI(), mesh.getTopology().getNumCellsJ(), mesh.getTopology().getNumCellsK(), m_step);
}

SubSampledMesh::~SubSampledMesh() 
{ 
}

void 
SubSampledMesh::adjust(double ratio)
{
  m_step = (size_t)(1/ratio);
  m_topology.adjust(m_step);
  m_depth->adjust(m_step);
  m_porosity->adjust(m_step);
}



