#ifndef _AdjustableEclipseMesh_H_
#define _AdjustableEclipseMesh_H_

#include <MeshVizXLM/mesh/MiVolumeMeshHexahedronIjk.h>
#include <MeshVizXLM/MbVec3.h>

#include "EclipseMesh.h"
#include "IndexedPillarMesh.h"
#include "SubSampledTopology.h"
#include "SubSampledScalarSet.h"

class SubSampledMesh : public EclipseMesh, virtual public MiVolumeMeshHexahedronIjk
{
public:
  SubSampledMesh(const IndexedPillarMesh& mesh, double ratio = 0.5);
  ~SubSampledMesh();
  
  void adjust(double ratio);

  /**
  * Returns the topology of this mesh.
  */
  const MiHexahedronTopologyExplicitIjk& getTopology() const {return m_topology; }
  /**
  * Returns the unstructured geometry of this mesh. 
  */
  const MiGeometryI& getGeometry() const { return m_fullResMesh.getGeometry(); }
  /* 
  * Computes bounding box center 
  */
  MbVec3f getCenter() const
  {
    return m_fullResMesh.getCenter();
  }

  MbVec3f getBBSize() const
  {
    return m_fullResMesh.getBBSize();
  }

  /*
  * return data set
  */
  const GridPropertyIjk& getDepth() const
  {
    return *m_depth;
  }

  /*
  * return data set
  */
  const GridPropertyIjk& getPorosity() const
  {
    return *m_porosity;
  }

  size_t getStep() const 
  {
    return m_step;
  }

private:
  size_t m_step;
  const IndexedPillarMesh& m_fullResMesh;
  SubSampledTopology m_topology;
  SubSampledScalarSet* m_depth;
  SubSampledScalarSet* m_porosity;
};


#endif


