#ifndef _AdjustableDataSetIjk_H
#define _AdjustableDataSetIjk_H

#include "GridPropertyIjk.h"

class SubSampledScalarSet : public GridPropertyIjk
{
public:
  SubSampledScalarSet(const MiScalardSetIjk& dataset, size_t numI, size_t numJ, size_t numK, size_t step);
  ~SubSampledScalarSet();

  void adjust(size_t step);

  double get(size_t i, size_t j, size_t k)  const;

  size_t getTimeStamp() const;

  DataBinding  getBinding() const { return MiDataSet::PER_CELL; }

  virtual std::string getName() const { return m_fullResDataset.getName(); }

protected:
  const MiScalardSetIjk& m_fullResDataset;
  mutable size_t m_dataTS;

  mutable size_t m_timeStamp;
  size_t m_numI;
  size_t m_numJ;
  size_t m_numK;
  size_t m_step;
};

//-----------------------------------------------------------------------------
inline
SubSampledScalarSet::SubSampledScalarSet(const MiScalardSetIjk& dataset, size_t numI, size_t numJ, size_t numK, size_t step) 
:  GridPropertyIjk("PillarProperty",MbScalardSet::PER_CELL),
  m_fullResDataset(dataset), m_dataTS(dataset.getTimeStamp()), m_timeStamp(MxTimeStamp::getTimeStamp()),
  m_numI(numI), m_numJ(numJ), m_numK(numK), m_step(step)
{
}

//-----------------------------------------------------------------------------
inline void
SubSampledScalarSet::adjust(size_t step)
{
  m_step = step;
  m_timeStamp = MxTimeStamp::getTimeStamp();
  m_dataTS = m_fullResDataset.getTimeStamp();
}

//-----------------------------------------------------------------------------
inline size_t
SubSampledScalarSet::getTimeStamp() const 
{ 
  if(m_dataTS != m_fullResDataset.getTimeStamp())
  {
    m_timeStamp = MxTimeStamp::getTimeStamp();
    m_dataTS = m_fullResDataset.getTimeStamp();
  }

  return m_timeStamp; 
}

//-----------------------------------------------------------------------------
inline
SubSampledScalarSet::~SubSampledScalarSet()
{
}

//-----------------------------------------------------------------------------
inline double 
SubSampledScalarSet::get(size_t i, size_t j, size_t k)  const
{
  return m_fullResDataset.get(i*m_step,j*m_step,k*m_step);
}

#endif


