#ifndef _AdjHexaTopologyExplicitIjk_H
#define _AdjHexaTopologyExplicitIjk_H

#include <MeshVizXLM/mesh/topology/MiHexahedronTopologyExplicitIjk.h>

class SubSampledTopology : public MiHexahedronTopologyExplicitIjk
{
public:
  SubSampledTopology(const MiHexahedronTopologyExplicitIjk& topology, size_t step);
  ~SubSampledTopology();

  void adjust(size_t step);

  /**
  * Returns a cell of this topology. The cell 
  * is identified by three id i,j,k.
  */
  void getCellNodeIndices(size_t i, size_t j, size_t k, size_t& n0, size_t& n1, size_t& n2, size_t& n3,
                                                        size_t& n4, size_t& n5, size_t& n6, size_t& n7)  const;

  size_t getEndNodeId() const;

  /**
  * Returns the number of cells on the first logical axis.
  */
  size_t getNumCellsI() const { return m_numI; }

  /**
  * Returns the number of cells on the second logical axis.
  */
  size_t getNumCellsJ() const { return m_numJ; }

  /**
  * Returns the number of cells on the third logical axis.
  */
  size_t getNumCellsK() const { return m_numK; }

  bool hasDeadCells() const { return m_fullResTopology.hasDeadCells(); }

  /** 
  * Returns true if the cell of index (i,j,k) should be ignored.
  * This value is ignored if the hasDeadCell() method returns false.
  * The default implementation returns always false.
  * @param (i,j,j) the index of the cell to check
  */ 
  bool isDead(size_t i, size_t j, size_t k) const;

  size_t getTimeStamp() const;

  size_t getNumCells() const;

protected:
  const MiHexahedronTopologyExplicitIjk& m_fullResTopology;
  size_t m_topoTS;

  mutable size_t m_timeStamp;
  size_t m_step;
  size_t m_numI;
  size_t m_numJ;
  size_t m_numK;
};

//-----------------------------------------------------------------------------
inline
SubSampledTopology::SubSampledTopology(const MiHexahedronTopologyExplicitIjk& topology, size_t /*step*/) 
: m_fullResTopology(topology), m_topoTS(m_fullResTopology.getTimeStamp()), m_step(0), m_numI(1), m_numJ(1), m_numK(1)
{
}

//-----------------------------------------------------------------------------
inline void
SubSampledTopology::adjust(size_t step) 
{
  if (m_step != step)
  {
    m_step = step;
    m_numI = m_fullResTopology.getNumCellsI() / m_step;
    if(m_numI == 0 ) ++m_numI;
    m_numJ = m_fullResTopology.getNumCellsJ() / m_step;
    if(m_numJ == 0 ) ++m_numJ;
    m_numK = m_fullResTopology.getNumCellsK() / m_step;
    if(m_numK == 0 ) ++m_numK;
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }
}

//-----------------------------------------------------------------------------
inline size_t
SubSampledTopology::getTimeStamp() const 
{ 
  if(m_topoTS != m_fullResTopology.getTimeStamp())
    m_timeStamp = MxTimeStamp::getTimeStamp();

  return m_timeStamp; 
}

//-----------------------------------------------------------------------------
inline
SubSampledTopology::~SubSampledTopology()
{
}

//-----------------------------------------------------------------------------
inline size_t
SubSampledTopology::getNumCells() const 
{
  return m_numI * m_numJ * m_numK;
}

//-----------------------------------------------------------------------------
inline void 
SubSampledTopology::getCellNodeIndices(size_t i, size_t j, size_t k, size_t& n0, size_t& n1, size_t& n2, size_t& n3,
                                                                             size_t& n4, size_t& n5, size_t& n6, size_t& n7)  const
{
  size_t dummy;
  size_t firstI = i*m_step;
  size_t lastI = i < m_numI-1 ? firstI + m_step-1 : m_fullResTopology.getNumCellsI()-1;
  size_t firstJ = j*m_step;
  size_t lastJ = j < m_numJ-1 ? firstJ + m_step-1 : m_fullResTopology.getNumCellsJ()-1;
  size_t firstK = k*m_step;
  size_t lastK = k < m_numK-1 ? firstK + m_step-1 : m_fullResTopology.getNumCellsK()-1;
  m_fullResTopology.getCellNodeIndices(firstI,firstJ,firstK,n0,dummy,dummy,dummy,dummy,dummy,dummy,dummy);
  m_fullResTopology.getCellNodeIndices(lastI,firstJ,firstK,dummy,n1,dummy,dummy,dummy,dummy,dummy,dummy);
  m_fullResTopology.getCellNodeIndices(lastI,lastJ,firstK,dummy,dummy,n2,dummy,dummy,dummy,dummy,dummy);
  m_fullResTopology.getCellNodeIndices(firstI,lastJ,firstK,dummy,dummy,dummy,n3,dummy,dummy,dummy,dummy);
  m_fullResTopology.getCellNodeIndices(firstI,firstJ,lastK,dummy,dummy,dummy,dummy,n4,dummy,dummy,dummy);
  m_fullResTopology.getCellNodeIndices(lastI,firstJ,lastK,dummy,dummy,dummy,dummy,dummy,n5,dummy,dummy);
  m_fullResTopology.getCellNodeIndices(lastI,lastJ,lastK,dummy,dummy,dummy,dummy,dummy,dummy,n6,dummy);
  m_fullResTopology.getCellNodeIndices(firstI,lastJ,lastK,dummy,dummy,dummy,dummy,dummy,dummy,dummy,n7);
}

//-----------------------------------------------------------------------------
inline size_t
SubSampledTopology::getEndNodeId() const
{
  return m_fullResTopology.getEndNodeId();
}

//-----------------------------------------------------------------------------
inline bool
SubSampledTopology::isDead(size_t i, size_t j, size_t k) const 
{
  size_t firstI = i*m_step;
  size_t lastI = i < m_numI-1 ? firstI + m_step-1 : m_fullResTopology.getNumCellsI()-1;
  size_t firstJ = j*m_step;
  size_t lastJ = j < m_numJ-1 ? firstJ + m_step-1 : m_fullResTopology.getNumCellsJ()-1;
  size_t firstK = k*m_step;
  size_t lastK = k < m_numK-1 ? firstK + m_step-1 : m_fullResTopology.getNumCellsK()-1;
  
  for(size_t ii = firstI; ii <= lastI; ++ii)
    for(size_t jj = firstJ; jj <= lastJ; ++jj)
      for(size_t kk = firstK; kk <= lastK; ++kk)
        if (m_fullResTopology.isDead(ii,jj,kk)) 
          return true;

  return false;
}

#endif


