//****************************************************************************
//                                                                         
// demonstration class to visualize scalar data on a volume mesh 
// with MeshViz XLM.
//                                                                         
//  author : J-Michel Godinaud                                             
//****************************************************************************

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>

#include <MeshVizXLM/mapping/nodes/MoMeshSkin.h>
#include <MeshVizXLM/mapping/nodes/MoMeshIsosurface.h>
#include <MeshVizXLM/mapping/nodes/MoMeshPlaneSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMeshOutline.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>
#include <MeshVizXLM/mapping/nodes/MoDrawStyle.h>

#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoClipPlane.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/draggers/SoJackDragger.h>
#include <Inventor/nodes/SoPickStyle.h>

#include <DialogViz/SoDialogVizAll.h>

#include "MeshViewerComponent.h"
#include "MyMesh.h"
#include "ProgressCallback.h"

/******************************************************************************/
//: Demonstration class to visualize scalar data on a volume mesh.
//   This is only a demonstration class, given with source code. 
//   As it uses only some of the features of 3D-data master, the limitations
//   of this class are not necessary limitation of 3D-data Master.
// 
//   This class is a part of the MeshViewer class. It cannot be instantiate
//   apart from MeshViewer. It controls the visualization of nodes that
//   depend on scalar data of a volume mesh.
//
//   The associated dialog box controls 
//(      . the choice of a scalar data set used to compute a level surface.
//         (see MoMeshIsosurface).
//       . the visibility and the value of this level surface.
//       . the visibility of the mesh skin (see MoMeshSkin).
//       . the visibility of a mesh cross section (see MoMeshPlaneSlice).
//       . the transparency of the skin.
//       . the activation of the clip plane (see SoClipPlane). When activated, 
//         the skin and the level surface are clipped.
//)
//   The position of the cross section, cross contour and clip plane are
//   relative to the position and orientation of the dragger. But this one
//   can be deconnected with a toggle button. In this case, the position 
//   of the cross section, cross contour and clip plane are not affected by
//   the motion of the dragger.
//    
/******************************************************************************/

class Mesh3DScalarViewer : public MeshViewerComponent {
public:
  Mesh3DScalarViewer(const MyMesh &myMesh, SoTopLevelDialog *dialogWindow, SoXtExaminerViewer *viewer);
    // Constructor.

  virtual ~Mesh3DScalarViewer() {}

  void buildSceneGraph( SoGroup *root, SoSFInt32 *which_dataset, Widget widget, SoGroup* meshGroup);
    // Builds the scene graph parts corresponding to scalar data on the mesh

  SoDialogGroup *buildDialogBox ();
    // Creates the dialog box.
  
  void updateAllConnectedToDragger(SoJackDragger *dragger, SbVec3f plane_normal);
    // When the dragger is connected, update the cross section, cross contour 
    // and clip plane.

  void preWriteAction();
    // Disables the field's connection during writing an Iv file

  void postWriteAction();
    // Re-enables the field's connection after writing an Iv file

  void setTransparencyValue(float val);
    // change the mesh skin level of transparency

  void setTransparencyType(SoGLRenderAction::TransparencyType type);
    // change the transparency type

  void setDatasetForIsosurface(int datasetid);
    // change the dataset used by the levelsurf

  void startCoordAnimation();
  void stopCoordAnimation();

  void changeCoord();

  virtual void updateParallelMode();

  virtual void enableProgressCallback(bool enable);

private:
  void enableConnection(SoNode *node, SbBool flag);
  void createPlaneViewer(Widget widget, SoGroup* meshGroup);
  void updatePlaneViewer();

  ProgressCallback               v_progressCallback;

  SoDialogGroup                   *v_DialogBox;

  MoMesh                        *v_MeshProperty;

  MoMeshSkin                     *v_meshSkin;
  MoMeshPlaneSlice               *v_meshPlaneSlice;
  MoMeshIsosurface               *v_meshIsosurface;
  MoMeshOutline                  *v_meshOutline;
  MoMeshOutline                  *v_planeOutline;

  SoClipPlane                    *v_ClipPlane;
  
  MoMaterial*                    v_globalMaterial;
  MoMaterial*                    v_skinMaterial;
  MoMaterial*                    v_outlineMaterial;
  
  // DrawStyles
  SoDrawStyle                    *v_widthDrawStyle;
  MoDrawStyle                    *v_globalDrawStyle;
  MoDrawStyle                    *v_outlineDrawStyle;

  SoSwitch                       *v_meshSkinSwitch;
  SoSwitch                       *v_meshPlaneSliceSwitch;
  SoSwitch                       *v_meshPlaneSliceOutlineSwitch;
  SoSwitch                       *v_meshIsosurfaceSwitch;
  SoSwitch                       *v_meshOutlineSwitch;

  int                            v_DataSetIndex;
  int                            v_isoScalarSetId;
  SoSFInt32*                     v_colorScalarSetId;

  float                          v_TransparencyValue;
  SoGLRenderAction::TransparencyType v_TransparencyType;

  const MyMesh&                   v_myMesh;

  char                           **v_DataSetNames;

  int                               v_animStep;
  float                            v_animScale;

  SbBool                         v_animateCoord;
  SbVec3f                        v_animCenter;

  SoXtExaminerViewer             *v_Viewer;
  SoXtPlaneViewer                *v_planeViewer;
  SoSeparator*                   v_planeRoot;
  SoGroup*                       v_meshGroup;

  SoTopLevelDialog               *v_DialogWindow;
};


