//****************************************************************************
//                                                                         
// demonstration class to visualize vector data on a volume mesh 
// with MeshViz XLM.
//                                                                         
//  author : J-Michel Godinaud                                             
//****************************************************************************


#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>

#include <MeshVizXLM/mapping/nodes/MoMeshVector.h>
#include <MeshVizXLM/mapping/nodes/MoMeshGridPlaneSlice.h>
#include <MeshVizXLM/mapping/nodes/MoMesh.h>

#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/draggers/SoJackDragger.h>
#include <Inventor/nodes/SoPickStyle.h>

#include <DialogViz/SoDialogVizAll.h>

#include "MeshViewerComponent.h"
#include "MyMesh.h"

/******************************************************************************/
//: Demonstration class to visualize vector data on a surface mesh.
//   This is only a demonstration class, given with source code. 
//   As it uses only some of the features of 3D-data master, the limitations
//   of this class are not necessary limitation of 3D-data Master.
// 
//   This class is a part of the MeshViewer class. It cannot be instantiate
//   apart from MeshViewer. It controls the representation of a vector field
//   on a volume mesh.
//
//   The associated dialog box controls 
//(      . the visibility of the vectors on a cross section inside the mesh.
//         (see MoMeshGridPlaneSlice and MoMeshVector)
//       . the fineness of the grid on which the vectors are drawn.
//       . the length of the vectors.
//       . the type of projection of the vectors.
//)
//   The position of the cross section on which the vectors are drawn is 
//   relative to the position and orientation of the dragger. But this one
//   can be deconnected with a toggle button. In this case, the position 
//   of the cross section is not affected by the motion of the dragger.
//
/******************************************************************************/
class Mesh3DVecViewer : public MeshViewerComponent 
{
public:
  Mesh3DVecViewer();
    // Constructor.

  virtual ~Mesh3DVecViewer() {}

  void buildSceneGraph( const MyMesh &myMesh, SoGroup *root, SoSFInt32 *which_dataset);
    // Builds the scene graph parts corresponding to the vector's field

  SoDialogComponent *buildDialogBox ();
    // Creates the dialog box.
  
  void updateAllConnectedToDragger(SoJackDragger *dragger, SbVec3f plane_normal);
    // When the dragger is connected, update the cross section position 

  void preWriteAction();
    // Disables the field's connection during writing an Iv file

  void postWriteAction();
    // Re-enables the field's connection after writing an Iv file

  void setLengthValue(float val);
    // change vector length

protected: 
  virtual void updateParallelMode();

private:
  void enableConnection(SoNode *node, SbBool flag);

  static void motionCallback(void *userData, SoDragger *dragger);
  
  SoDialogGroup               *v_DialogBox;

  SoSwitch                    *v_meshVectorSwitch;

  float                       v_vecLengthFactor;

  MoMeshGridPlaneSlice*       v_meshGridPlaneSlice;
  MoMesh*                     v_meshGrid;
  MoMeshVector*               v_meshVector;
};


