#include "MeshFilterViewer.h"
#include "commonAuditor.h"

//-------------------------------------------------------------------------------------
class InOutChoice : public SoDialogChoiceAuditor 
{
  MeshFilterViewer *mViewer;
public:
  InOutChoice(MeshFilterViewer *mvw) { this->mViewer = mvw; }
  void dialogChoice (SoDialogChoice *dc) 
  {
    mViewer->switchInOutFilter(dc->selectedItem.getValue());
  }
};

//-------------------------------------------------------------------------------------
void MeshFilterViewer::buildSceneGraph(const MyMesh& myMesh, 
                                       SoGroup *sceneFilter)
{
  sceneFilter->setName("Filter_Scene");

  v_moCellFilterIn = new MoCellFilter;
  v_cellFilterIn = new CellFilterIn(myMesh);
  v_moCellFilterIn->setCellFilter(v_cellFilterIn);

  v_moCellFilterOut = new MoCellFilter;
  v_cellFilterOut = new CellFilterOut(myMesh);
  v_moCellFilterOut->setCellFilter(v_cellFilterOut);

  v_inOutFilterSwitch = new SoSwitch;
  v_inOutFilterSwitch->whichChild = 0;

  v_enableCellFilterSwitch = new SoSwitch;
  v_enableCellFilterSwitch->whichChild = SO_SWITCH_NONE;

  SbBox3f bbox = myMesh.getBoundingBoxf();
  float sx,sy,sz;
  bbox.getSize(sx,sy,sz);
  v_BoxDragger = new SoHandleBoxDragger;
  v_BoxDragger->translation = bbox.getCenter();
  v_BoxDragger->scaleFactor.setValue(sx/5,sy/5,sz/1.5f);
  v_BoxDragger->addMotionCallback((SoDraggerCB *)&MeshFilterViewer::motionBoxCallback,this);
  setFilterBox(v_BoxDragger);

  v_BoxDraggerSwitch = new SoSwitch;
  v_BoxDraggerSwitch->whichChild = SO_SWITCH_NONE;

  {
    // assemble the scene graph of this viewer
    sceneFilter->addChild(v_BoxDraggerSwitch);
    {
      v_BoxDraggerSwitch->addChild(v_BoxDragger) ;
    }
    sceneFilter->addChild(v_enableCellFilterSwitch);
    {
      v_enableCellFilterSwitch->addChild(v_inOutFilterSwitch) ;
      {
        v_inOutFilterSwitch->addChild(v_moCellFilterIn);
        v_inOutFilterSwitch->addChild(v_moCellFilterOut);
      }
    }
  }
}


//-------------------------------------------------------------------------------------
void MeshFilterViewer::motionBoxCallback(void *user_data, SoHandleBoxDragger *dragger) 
{
  MeshFilterViewer *viewer = (MeshFilterViewer *)user_data;
  viewer->setFilterBox(dragger);
}


//-------------------------------------------------------------------------------------
void MeshFilterViewer::setFilterBox(SoHandleBoxDragger *dragger) 
{
  SbVec3f center = dragger->translation.getValue();
  SbVec3f scale  = dragger->scaleFactor.getValue();
  SbVec3f bmin = center - scale*1;
  SbVec3f bmax = center + scale*1;
  v_cellFilterOut->setBbox(SbBox3f(bmin,bmax));
  v_moCellFilterOut->setCellFilter(v_cellFilterOut);
  v_cellFilterIn->setBbox(SbBox3f(bmin,bmax));
  v_moCellFilterIn->setCellFilter(v_cellFilterIn);

}


//-------------------------------------------------------------------------------------
SoDialogComponent *
MeshFilterViewer::buildDialogBox (const MyMesh&)
{
  SbString ivPath = SoPreferences::getString("OIVHOME",".") + "/examples/source/MeshVizXLM/demonstrators/MeshViewer/GuiTabFilter.iv";

  SoInput myInput;
  if (!myInput.openFile(ivPath.getString()))
    exit (1);
  SoGroup *myGroup = SoDB::readAll( &myInput );
  if (myGroup == NULL) exit (1);
  v_DialogBoxFilter = (SoDialogGroup *)myGroup->getChild(0);

  // box dragger check
  SoDialogCheckBox* boxCheck = (SoDialogCheckBox *)v_DialogBoxFilter->searchForAuditorId("BoxDraggerCheck");
  boxCheck->addAuditor(new CheckSwitchAllAuditor(v_BoxDraggerSwitch));
  boxCheck->state = (v_BoxDraggerSwitch->whichChild.getValue() != SO_SWITCH_NONE);

  // filter check
  SoDialogCheckBox* enableFilterCheck = (SoDialogCheckBox *)v_DialogBoxFilter->searchForAuditorId("EnableFilterCheck");
  enableFilterCheck->addAuditor(new CheckSwitchAllAuditor(v_enableCellFilterSwitch));
  enableFilterCheck->state = (v_enableCellFilterSwitch->whichChild.getValue() == SO_SWITCH_ALL);

  // In/out filter choice
  SoDialogChoice* inOutChoice = (SoDialogChoice *)v_DialogBoxFilter->searchForAuditorId("InOutFilter");
  inOutChoice->addAuditor(new InOutChoice(this));

  return v_DialogBoxFilter;
}


// CellFilterIn Class
bool 
CellFilterIn::acceptCell(size_t cellIndex) const 
{
  size_t nodeId = m_myMesh.mesh.getTopology().getCell(cellIndex)->getNodeIndex(0);
  MbVec3d coord0 = m_myMesh.mesh.getGeometry().getCoord(nodeId);
  SbVec3f coord0f((float)(coord0[0]),(float)(coord0[1]),(float)(coord0[2]));
  return m_bbox.intersect(coord0f);
}

 


