//****************************************************************************
//                                                                         
// demonstration class to manager cell filtering on a mesh with MeshViz XLM.
//                                                                         
//  author : J-Michel Godinaud                                             
//****************************************************************************

#include <MeshVizXLM/mapping/nodes/MoCellFilter.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterI.h> 

#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/draggers/SoTabBoxDragger.h>
#include <Inventor/draggers/SoHandleBoxDragger.h>

#include <DialogViz/SoDialogVizAll.h>
#include "MeshViewerComponent.h"
#include "MyMesh.h"

#include <MeshVizXLM/MxTimeStamp.h>

//---------------------------------------------------------------------------------------------------------------------
class CellFilterIn : public MiCellFilterI 
{
public :
  CellFilterIn(const MyMesh& myMesh) 
    : m_myMesh(myMesh),
    m_bbox(m_myMesh.getBoundingBoxf()),
    m_ts(MxTimeStamp::getTimeStamp())
  {}

  virtual bool acceptCell(size_t cellIndex) const;
  virtual size_t  getTimeStamp () const { return m_ts; }
  void setBbox(SbBox3f bbox) 
  { 
    m_bbox = bbox; 
    m_ts = MxTimeStamp::getTimeStamp();
  }

protected:
  const MyMesh& m_myMesh;
  SbBox3f       m_bbox;
  size_t        m_ts;
};

//---------------------------------------------------------------------------------------------------------------------
class CellFilterOut : public CellFilterIn 
{
public :
  CellFilterOut(const MyMesh& myMesh) 
    : CellFilterIn(myMesh)
  {
  }
  virtual bool acceptCell(size_t cellIndex) const
  {
    return !CellFilterIn::acceptCell(cellIndex);
  }
};


/******************************************************************************/
class MeshFilterViewer : public MeshViewerComponent {
public:

  void buildSceneGraph(const MyMesh& myMesh, SoGroup *root);

    // Builds the scene graph parts corresponding to scalar data on the mesh

  SoDialogComponent *buildDialogBox (const MyMesh& myMesh);
    // Creates the dialog box.
  
  void setFilterBox(SoHandleBoxDragger *dragger) ;

  void switchInOutFilter(int choice) 
  {
    v_inOutFilterSwitch->whichChild = choice;
  }

  virtual ~MeshFilterViewer()
  {
    delete v_cellFilterIn;
    delete v_cellFilterOut;
  }

private:
  SoDialogGroup                  *v_DialogBoxFilter;
  CellFilterIn                   *v_cellFilterIn;
  CellFilterOut                  *v_cellFilterOut;
  MoCellFilter                   *v_moCellFilterIn;
  MoCellFilter                   *v_moCellFilterOut;
  SoSwitch                       *v_BoxDraggerSwitch;
  SoSwitch                       *v_enableCellFilterSwitch;
  SoSwitch                       *v_inOutFilterSwitch;

  SoHandleBoxDragger             *v_BoxDragger;
  SoTopLevelDialog               *v_DialogWindow;

  static void motionBoxCallback(void *userData, SoHandleBoxDragger *dragger);
};


