#include "MeshProbeSheet.h"
#include <MeshVizXLM/mapping/nodes/MoMeshCellShape.h> 

#include <Inventor/nodes/SoBlinker.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoCoordinate3.h>

#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream>

//-------------------------------------------------------------------------------------
MeshProbeSheet::MeshProbeSheet(SoGroup* infoRoot, MoMeshCellShape* cellShape, SoCoordinate3* coord)
: v_probeInMesh(false),
  v_inMeshSwitch(NULL),
  v_cellShape(cellShape),
  v_coord(coord)
{
  v_infoRoot = infoRoot ; 

  // build probe information text
  v_cellIndexText = new SoText2;
  v_cellIndexText->justification = SoText2::LEFT;

  SoTranslation *trans2 = new SoTranslation;
  trans2->translation.setValue(0.F, -0.05F, 0);
  v_probeValueText = new SoText2;
  v_probeValueText->justification = SoText2::LEFT;

  SoText2 *text_probe_out = new SoText2;
  text_probe_out->string = "probe out of mesh !";

  SoBlinker *text_blinker = new SoBlinker;
  text_blinker->whichChild = SO_SWITCH_NONE;

  v_textSwitch = new SoSwitch;
  v_textSwitch->whichChild = 0;

  SoTranslation *trans1 = new SoTranslation;
  trans1->translation.setValue(-1.9F, 1.90F, 0);

  SoGroup *group_probe_text = new SoGroup;

  // assemble probe_text_info_group
  {
    infoRoot->addChild(trans1);
    infoRoot->addChild(v_textSwitch);
    {
      v_textSwitch->addChild(group_probe_text);
      {
        group_probe_text->addChild(v_cellIndexText);
        group_probe_text->addChild(trans2);
        group_probe_text->addChild(v_probeValueText);
      }
      v_textSwitch->addChild(text_blinker);
      {
        text_blinker->addChild(text_probe_out);
      }
    }
  }
}

//------------------------------------------------------------------------
void 
MeshProbeSheet::motionCallback(size_t cellId, const MeXScalardSetI &scalars, const MeXVec3dSetI &/*vectors*/)
{
  bool insideMesh = (cellId != std::numeric_limits<size_t>::max());
  if (insideMesh)
  {
    if (!v_probeInMesh) 
      this->entersMesh();

    this->updateCell(cellId);

    if (scalars.getSize() > 0)
      this->updateValue(scalars.get(0));
    else
      this->updateValue();
  }
  else if (v_probeInMesh) 
      this->leavesMesh();
}

//------------------------------------------------------------------------
void 
MeshProbeSheet::setTextInfo(SbVec3f& point, size_t cellId, double value, const std::string& dataSetName)
{
  bool insideMesh = (cellId != std::numeric_limits<size_t>::max());
  if (insideMesh)
  {
    if (!v_probeInMesh) 
      this->entersMesh();

    this->updateCell(cellId);
    this->updateValue(value,dataSetName);
    v_coord->point.setValue(point);
  }
  else if (v_probeInMesh) 
      this->leavesMesh();
}

//------------------------------------------------------------------------
void 
MeshProbeSheet::updateCell(size_t cellId) 
{
  std::ostringstream str;
  str << "cell index : " << cellId;
  v_cellIndexText->string = str.str();
  v_cellShape->cellIndices.setValue(int32_t(cellId));
}

//------------------------------------------------------------------------
void 
MeshProbeSheet::updateValue() 
{
  v_probeValueText->string = "no mapped value";
}

//------------------------------------------------------------------------
void 
MeshProbeSheet::updateValue(double probeValue, const std::string& dataSetName) 
{
  if (probeValue != DBL_MAX)
  {
    std::ostringstream str;
    str << dataSetName << " at probe : " << probeValue;
    v_probeValueText->string = str.str();
  }
  else
    updateValue();
}


//------------------------------------------------------------------------
void 
MeshProbeSheet::entersMesh() 
{
  v_textSwitch->whichChild = 0;
  v_probeInMesh = true;
  if (v_inMeshSwitch)
    v_inMeshSwitch->whichChild = SO_SWITCH_ALL;
}

//------------------------------------------------------------------------
void 
MeshProbeSheet::leavesMesh() 
{
  v_textSwitch->whichChild = 1;
  v_cellShape->cellIndices.setNum(0);
  v_probeInMesh = false;
  if (v_inMeshSwitch)
    v_inMeshSwitch->whichChild = SO_SWITCH_NONE;
}

//------------------------------------------------------------------------
void 
MeshProbeSheet::switchOnText()
{
  if ( v_probeInMesh)
    entersMesh();
  else
    leavesMesh();
}


